/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;

final class LayerBStreamedEXTDTAReaderInputStream
extends EXTDTAReaderInputStream {
    private final DDMReader reader;
    private ByteArrayInputStream currentBuffer;

    LayerBStreamedEXTDTAReaderInputStream(DDMReader reader) throws DRDAProtocolException {
        this.reader = reader;
        this.currentBuffer = reader.readLOBInitStream();
    }

    public final int read() throws IOException {
        int val;
        int n = val = this.currentBuffer == null ? -1 : this.currentBuffer.read();
        if (val < 0) {
            val = this.refreshCurrentBuffer();
        }
        return val;
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        int val = this.currentBuffer.read(b, off, len);
        if (val < 0 && this.reader.doingLayerBStreaming()) {
            this.currentBuffer = this.reader.readLOBContinuationStream();
            val = this.currentBuffer.read(b, off, len);
        }
        return val;
    }

    public final int available() {
        return this.currentBuffer.available();
    }

    private int refreshCurrentBuffer() throws IOException {
        if (!this.reader.doingLayerBStreaming()) {
            return -1;
        }
        this.currentBuffer = this.reader.readLOBContinuationStream();
        return this.currentBuffer.read();
    }
}

