/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.daemon;

import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.services.daemon.ServiceRecord;

public class BasicDaemon
implements DaemonService,
Runnable {
    private int numClients;
    private static final int OPTIMAL_QUEUE_SIZE = 100;
    private final Vector subscription;
    protected final ContextService contextService;
    protected final ContextManager contextMgr;
    private final List highPQ;
    private final List normPQ;
    private int nextService;
    private boolean awakened;
    private boolean waiting;
    private boolean inPause;
    private boolean running;
    private boolean stopRequested;
    private boolean stopped;
    private long lastServiceTime;
    private int earlyWakeupCount;

    public BasicDaemon(ContextService contextService) {
        this.contextService = contextService;
        this.contextMgr = contextService.newContextManager();
        this.subscription = new Vector(1, 1);
        this.highPQ = new LinkedList();
        this.normPQ = new LinkedList();
        this.lastServiceTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int subscribe(Serviceable newClient, boolean onDemandOnly) {
        ServiceRecord clientRecord;
        int clientNumber;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            clientNumber = this.numClients++;
            clientRecord = new ServiceRecord(newClient, onDemandOnly, true);
            this.subscription.insertElementAt(clientRecord, clientNumber);
        }
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "subscribed client # " + clientNumber + " : " + clientRecord);
        }
        return clientNumber;
    }

    public void unsubscribe(int clientNumber) {
        if (clientNumber < 0 || clientNumber > this.subscription.size()) {
            return;
        }
        this.subscription.setElementAt(null, clientNumber);
    }

    public void serviceNow(int clientNumber) {
        if (clientNumber < 0 || clientNumber > this.subscription.size()) {
            return;
        }
        ServiceRecord clientRecord = (ServiceRecord)this.subscription.elementAt(clientNumber);
        if (clientRecord == null) {
            return;
        }
        clientRecord.called();
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue(Serviceable newClient, boolean serviceNow) {
        int highPQsize;
        ServiceRecord clientRecord = new ServiceRecord(newClient, false, false);
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "enqueing work, urgent = " + serviceNow + ":" + newClient);
        }
        List queue = serviceNow ? this.highPQ : this.normPQ;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            queue.add(clientRecord);
            highPQsize = this.highPQ.size();
            if (SanityManager.DEBUG_ON("memoryLeakTrace") && highPQsize > 200) {
                System.out.println("memoryLeakTrace:BasicDaemon " + highPQsize);
            }
        }
        if (serviceNow && !this.awakened) {
            this.wakeUp();
        }
        if (serviceNow) {
            return highPQsize > 100;
        }
        return false;
    }

    public synchronized void clear() {
        this.normPQ.clear();
        this.highPQ.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceRecord nextAssignment(boolean urgent) {
        ServiceRecord clientRecord;
        while (this.nextService < this.subscription.size()) {
            if ((clientRecord = (ServiceRecord)this.subscription.elementAt(this.nextService++)) == null || !clientRecord.needImmediateService() && (urgent || !clientRecord.needService())) continue;
            return clientRecord;
        }
        clientRecord = null;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            if (!this.highPQ.isEmpty()) {
                clientRecord = (ServiceRecord)this.highPQ.remove(0);
            }
        }
        if (urgent || clientRecord != null) {
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, clientRecord == null ? "No more urgent assignment " : "Next urgent assignment : " + clientRecord);
            }
            return clientRecord;
        }
        clientRecord = null;
        basicDaemon = this;
        synchronized (basicDaemon) {
            if (!this.normPQ.isEmpty()) {
                clientRecord = (ServiceRecord)this.normPQ.remove(0);
                if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                    SanityManager.DEBUG(DaemonService.DaemonTrace, "Next normal enqueued : " + clientRecord);
                }
            }
        }
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace) && clientRecord == null) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "No more assignment");
        }
        return clientRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceClient(ServiceRecord clientRecord) {
        clientRecord.serviced();
        Serviceable client = clientRecord.client;
        if (client == null) {
            return;
        }
        ContextManager cm = this.contextMgr;
        SanityManager.ASSERT(cm != null, "Context manager is null");
        SanityManager.ASSERT(client != null, "client is null");
        try {
            int status = client.performWork(cm);
            if (clientRecord.subscriber) {
                return;
            }
            if (status == 2) {
                List queue = client.serviceASAP() ? this.highPQ : this.normPQ;
                BasicDaemon basicDaemon = this;
                synchronized (basicDaemon) {
                    queue.add(clientRecord);
                    if (SanityManager.DEBUG_ON("memoryLeakTrace") && queue.size() > 200) {
                        System.out.println("memoryLeakTrace:BasicDaemon " + queue.size());
                    }
                }
            }
            return;
        }
        catch (Throwable e) {
            SanityManager.showTrace(e);
            cm.cleanupOnError(e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.contextService.setCurrentContextManager(this.contextMgr);
        if (SanityManager.DEBUG_ON(DaemonService.DaemonOff)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "DaemonOff is set in properties, background Daemon not run");
            return;
        }
        SanityManager.DEBUG(DaemonService.DaemonTrace, "running");
        while (!this.stopRequested()) {
            boolean urgentOnly = this.rest();
            if (this.stopRequested()) break;
            if (this.inPause()) continue;
            this.work(urgentOnly);
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.running = false;
            this.stopped = true;
        }
        this.contextMgr.cleanupOnError(StandardException.normalClose());
        this.contextService.resetCurrentContextManager(this.contextMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "pausing daemon");
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.inPause = true;
            while (this.running) {
                if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                    SanityManager.DEBUG(DaemonService.DaemonTrace, "waiting for daemon run to finish");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "daemon paused");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.inPause = false;
        }
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "daemon resumed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.stopped) {
            return;
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.stopRequested = true;
            this.notifyAll();
        }
        this.pause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilQueueIsEmpty() {
        while (true) {
            BasicDaemon basicDaemon = this;
            synchronized (basicDaemon) {
                boolean noSubscriptionRequests = true;
                for (int urgentServiced = 0; urgentServiced < this.subscription.size(); ++urgentServiced) {
                    ServiceRecord clientRecord = (ServiceRecord)this.subscription.elementAt(urgentServiced);
                    if (clientRecord == null || !clientRecord.needService()) continue;
                    noSubscriptionRequests = false;
                    break;
                }
                if (this.highPQ.isEmpty() && noSubscriptionRequests && !this.running) {
                    return;
                }
                this.notifyAll();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private synchronized boolean stopRequested() {
        return this.stopRequested;
    }

    private synchronized boolean inPause() {
        return this.inPause;
    }

    protected synchronized void wakeUp() {
        if (!this.awakened) {
            this.awakened = true;
            if (this.waiting) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rest() {
        long currenttime;
        boolean urgentOnly;
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "going back to rest");
        }
        boolean checkWallClock = false;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            try {
                if (!this.awakened) {
                    this.waiting = true;
                    this.wait(10000L);
                    this.waiting = false;
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.nextService = 0;
            urgentOnly = this.awakened;
            if (urgentOnly && this.earlyWakeupCount++ > 20) {
                this.earlyWakeupCount = 0;
                checkWallClock = true;
            }
            this.awakened = false;
        }
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, urgentOnly ? "someone wakes me up" : "wakes up by myself");
        }
        if (checkWallClock && (currenttime = System.currentTimeMillis()) - this.lastServiceTime > 10000L) {
            this.lastServiceTime = currenttime;
            urgentOnly = false;
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, "wall clock check says service all");
            }
        }
        return urgentOnly;
    }

    /*
     * Exception decompiling
     */
    private void work(boolean urgentOnly) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void yield() {
        Thread currentThread = Thread.currentThread();
        int oldPriority = currentThread.getPriority();
        if (oldPriority <= 1) {
            currentThread.yield();
        } else {
            ModuleFactory mf = Monitor.getMonitor();
            if (mf != null) {
                mf.setThreadPriority(1);
            }
            currentThread.yield();
            if (mf != null) {
                mf.setThreadPriority(oldPriority);
            }
        }
    }
}

