/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.BitSet;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;

public class IntersectOrExceptNode
extends SetOperatorNode {
    private int opType;
    public static final int INTERSECT_OP = 1;
    public static final int EXCEPT_OP = 2;
    private boolean addNewNodesCalled;
    private int[] intermediateOrderByColumns;
    private int[] intermediateOrderByDirection;
    private boolean[] intermediateOrderByNullsLow;

    public void init(Object opType, Object leftResult, Object rightResult, Object all, Object tableProperties) throws StandardException {
        super.init(leftResult, rightResult, all, tableProperties);
        this.opType = (Integer)opType;
    }

    private int getOpType() {
        return this.opType;
    }

    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.intermediateOrderByColumns = new int[this.getResultColumns().size()];
        this.intermediateOrderByDirection = new int[this.intermediateOrderByColumns.length];
        this.intermediateOrderByNullsLow = new boolean[this.intermediateOrderByColumns.length];
        if (this.orderByList != null) {
            int i;
            BitSet colsOrdered = new BitSet(this.intermediateOrderByColumns.length);
            int orderByListSize = this.orderByList.size();
            int intermediateOrderByIdx = 0;
            for (i = 0; i < orderByListSize; ++i) {
                int columnIdx;
                if (colsOrdered.get(i)) continue;
                OrderByColumn orderByColumn = this.orderByList.getOrderByColumn(i);
                this.intermediateOrderByDirection[intermediateOrderByIdx] = orderByColumn.isAscending() ? 1 : -1;
                this.intermediateOrderByNullsLow[intermediateOrderByIdx] = orderByColumn.isNullsOrderedLow();
                this.intermediateOrderByColumns[intermediateOrderByIdx] = columnIdx = orderByColumn.getResultColumn().getColumnPosition() - 1;
                colsOrdered.set(columnIdx);
                ++intermediateOrderByIdx;
            }
            for (i = 0; i < this.intermediateOrderByColumns.length; ++i) {
                if (colsOrdered.get(i)) continue;
                this.intermediateOrderByDirection[intermediateOrderByIdx] = 1;
                this.intermediateOrderByNullsLow[intermediateOrderByIdx] = false;
                this.intermediateOrderByColumns[intermediateOrderByIdx] = i;
                ++intermediateOrderByIdx;
            }
            this.orderByList = null;
        } else {
            for (int i = 0; i < this.intermediateOrderByColumns.length; ++i) {
                this.intermediateOrderByDirection[i] = 1;
                this.intermediateOrderByNullsLow[i] = false;
                this.intermediateOrderByColumns[i] = i;
            }
        }
        this.pushOrderingDown(this.leftResultSet);
        this.pushOrderingDown(this.rightResultSet);
        return super.preprocess(numTables, gbl, fromList);
    }

    private void pushOrderingDown(ResultSetNode rsn) throws StandardException {
        ContextManager cm = this.getContextManager();
        NodeFactory nf = this.getNodeFactory();
        OrderByList orderByList = (OrderByList)nf.getNode(7, cm);
        for (int i = 0; i < this.intermediateOrderByColumns.length; ++i) {
            OrderByColumn orderByColumn = (OrderByColumn)nf.getNode(104, nf.getNode(70, ReuseFactory.getInteger(this.intermediateOrderByColumns[i] + 1), cm), cm);
            if (this.intermediateOrderByDirection[i] < 0) {
                orderByColumn.setDescending();
            }
            if (this.intermediateOrderByNullsLow[i]) {
                orderByColumn.setNullsOrderedLow();
            }
            orderByList.addOrderByColumn(orderByColumn);
        }
        orderByList.bindOrderByColumns(rsn);
        rsn.pushOrderByList(orderByList);
    }

    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, null, outerCost);
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, null, outerCost);
        CostEstimate costEstimate = this.getCostEstimate(optimizer);
        CostEstimate leftCostEstimate = this.leftResultSet.getCostEstimate();
        CostEstimate rightCostEstimate = this.rightResultSet.getCostEstimate();
        costEstimate.setCost(leftCostEstimate.getEstimatedCost() + rightCostEstimate.getEstimatedCost(), this.getRowCountEstimate(leftCostEstimate.rowCount(), rightCostEstimate.rowCount()), this.getSingleScanRowCountEstimate(leftCostEstimate.singleScanRowCount(), rightCostEstimate.singleScanRowCount()));
        return costEstimate;
    }

    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        Optimizable retOptimizable = super.modifyAccessPath(outerTables);
        if (this.addNewNodesCalled) {
            return retOptimizable;
        }
        return (Optimizable)((Object)this.addNewNodes());
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        ResultSetNode retRSN = super.modifyAccessPaths();
        if (this.addNewNodesCalled) {
            return retRSN;
        }
        return this.addNewNodes();
    }

    private ResultSetNode addNewNodes() throws StandardException {
        if (this.addNewNodesCalled) {
            return this;
        }
        this.addNewNodesCalled = true;
        if (this.orderByList == null) {
            return this;
        }
        return (ResultSetNode)this.getNodeFactory().getNode(140, this, this.orderByList, this.tableProperties, this.getContextManager());
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.assignResultSetNumber();
        this.costEstimate = this.getFinalCostEstimate();
        acb.pushGetResultSetFactoryExpression(mb);
        this.getLeftResultSet().generate(acb, mb);
        this.getRightResultSet().generate(acb, mb);
        acb.pushThisAsActivation(mb);
        mb.push(this.resultSetNumber);
        mb.push(this.costEstimate.getEstimatedRowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.push(this.getOpType());
        mb.push(this.all);
        mb.push(this.getCompilerContext().addSavedObject(this.intermediateOrderByColumns));
        mb.push(this.getCompilerContext().addSavedObject(this.intermediateOrderByDirection));
        mb.push(this.getCompilerContext().addSavedObject(this.intermediateOrderByNullsLow));
        mb.callMethod((short)185, null, "getSetOpResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 11);
    }

    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        CostEstimate leftCE = this.leftResultSet.getFinalCostEstimate();
        CostEstimate rightCE = this.rightResultSet.getFinalCostEstimate();
        this.finalCostEstimate = this.getNewCostEstimate();
        this.finalCostEstimate.setCost(leftCE.getEstimatedCost() + rightCE.getEstimatedCost(), this.getRowCountEstimate(leftCE.rowCount(), rightCE.rowCount()), this.getSingleScanRowCountEstimate(leftCE.singleScanRowCount(), rightCE.singleScanRowCount()));
        return this.finalCostEstimate;
    }

    String getOperatorName() {
        switch (this.opType) {
            case 1: {
                return "INTERSECT";
            }
            case 2: {
                return "EXCEPT";
            }
        }
        SanityManager.THROWASSERT("Invalid intersectOrExcept opType: " + this.opType);
        return "?";
    }

    double getRowCountEstimate(double leftRowCount, double rightRowCount) {
        switch (this.opType) {
            case 1: {
                return Math.min(leftRowCount, rightRowCount) / 2.0;
            }
            case 2: {
                return (leftRowCount + Math.max(0.0, leftRowCount - rightRowCount)) / 2.0;
            }
        }
        SanityManager.THROWASSERT("Invalid intersectOrExcept opType: " + this.opType);
        return 1.0;
    }

    double getSingleScanRowCountEstimate(double leftSingleScanRowCount, double rightSingleScanRowCount) {
        return this.getRowCountEstimate(leftSingleScanRowCount, rightSingleScanRowCount);
    }
}

