/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.conglomerate.ScanControllerRowSource;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.sort.Scan;
import org.apache.derby.impl.store.access.sort.SortBuffer;

public class SortBufferRowSource
extends Scan
implements ScanControllerRowSource {
    SortBuffer sortBuffer = null;
    protected TransactionManager tran = null;
    private int maxFreeListSize;
    private boolean writingToDisk;
    private SortObserver sortObserver;

    SortBufferRowSource(SortBuffer sortBuffer, TransactionManager tran, SortObserver sortObserver, boolean writingToDisk, int maxFreeListSize) {
        this.sortBuffer = sortBuffer;
        this.tran = tran;
        this.sortObserver = sortObserver;
        this.writingToDisk = writingToDisk;
        this.maxFreeListSize = maxFreeListSize;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() {
        if (this.sortBuffer == null) {
            return null;
        }
        DataValueDescriptor[] retval = this.sortBuffer.removeFirst();
        if (retval != null && this.writingToDisk) {
            this.sortObserver.addToFreeList(retval, this.maxFreeListSize);
        }
        return retval;
    }

    public boolean needsRowLocation() {
        return false;
    }

    public boolean needsToClone() {
        return false;
    }

    public void rowLocation(RowLocation rl) {
        SanityManager.THROWASSERT("unexpected call to RowSource.rowLocation");
    }

    public FormatableBitSet getValidColumns() {
        return null;
    }

    public void close() {
        if (this.sortBuffer != null) {
            this.sortBuffer.close();
            this.sortBuffer = null;
        }
        this.tran.closeMe(this);
    }

    public boolean closeForEndTransaction(boolean closeHeldScan) {
        SanityManager.ASSERT(closeHeldScan, "Sort scan should not be held open across commit.");
        this.close();
        return true;
    }

    public void closeRowSource() {
        this.close();
    }

    public boolean next() throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }

    public void fetchWithoutQualify(DataValueDescriptor[] result) throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }

    public void fetch(DataValueDescriptor[] result) throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }

    public final boolean fetchNext(DataValueDescriptor[] row) throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }
}

