/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;

public final class AllocPageOperation
extends PhysicalPageOperation {
    protected long newPageNumber;
    protected int doStatus;
    protected int undoStatus;

    public AllocPageOperation(AllocPage allocPage, long pageNumber, int doStatus, int undoStatus) throws StandardException {
        super(allocPage);
        this.newPageNumber = pageNumber;
        this.doStatus = doStatus;
        this.undoStatus = undoStatus;
    }

    public AllocPageOperation() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeLong(out, this.newPageNumber);
        CompressedNumber.writeInt(out, this.doStatus);
        CompressedNumber.writeInt(out, this.undoStatus);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.newPageNumber = CompressedNumber.readLong(in);
        this.doStatus = CompressedNumber.readInt(in);
        this.undoStatus = CompressedNumber.readInt(in);
    }

    public int getTypeFormatId() {
        return 111;
    }

    public final void doMe(Transaction tran, LogInstant instant, LimitObjectInput in) throws StandardException {
        SanityManager.ASSERT(this.page instanceof AllocPage);
        ((AllocPage)this.page).setPageStatus(instant, this.newPageNumber, this.doStatus);
    }

    public void undoMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException {
        SanityManager.ASSERT(undoPage != null, "undo Page null");
        SanityManager.ASSERT(undoPage instanceof AllocPage, "undo Page is not an allocPage");
        ((AllocPage)undoPage).setPageStatus(CLRInstant, this.newPageNumber, this.undoStatus);
    }

    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRinstant, LimitObjectInput in) {
        SanityManager.THROWASSERT("cannot call restoreMe on BI_AllocPageOperation");
    }

    public String toString() {
        String str = super.toString();
        str = str + " Change page allocation status of " + this.newPageNumber + " to " + this.doStatus + "(undo " + this.undoStatus + ")";
        return str;
    }
}

