/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.RAFContainer;
import org.apache.derby.io.StorageFile;

class TempRAFContainer
extends RAFContainer {
    protected int inUseCount;

    TempRAFContainer(BaseDataFileFactory factory) {
        super(factory);
    }

    public Cacheable setIdentity(Object key) throws StandardException {
        ContainerKey newIdentity = (ContainerKey)key;
        if (newIdentity.getSegmentId() != -1L) {
            RAFContainer realContainer = new RAFContainer(this.dataFactory);
            return realContainer.setIdent(newIdentity);
        }
        return super.setIdentity(newIdentity);
    }

    public Cacheable createIdentity(Object key, Object createParameter) throws StandardException {
        ContainerKey newIdentity = (ContainerKey)key;
        if (newIdentity.getSegmentId() != -1L) {
            RAFContainer realContainer = new RAFContainer(this.dataFactory);
            return realContainer.createIdentity(newIdentity, createParameter);
        }
        return this.createIdent(newIdentity, createParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainer(LogInstant instant, boolean leaveStub) throws StandardException {
        this.pageCache.discard(this.identity);
        TempRAFContainer tempRAFContainer = this;
        synchronized (tempRAFContainer) {
            this.setDroppedState(true);
            this.setCommittedDropState(true);
            this.setDirty(false);
            this.needsSync = false;
        }
        this.removeFile(this.getFileName(this.identity, false, false, false));
    }

    protected int preAllocate(long lastPreallocPagenum, int preAllocSize) {
        return 0;
    }

    protected void writePage(long pageNumber, byte[] pageData, boolean syncPage) throws IOException, StandardException {
        if (!this.getDroppedState()) {
            super.writePage(pageNumber, pageData, false);
        }
        this.needsSync = false;
    }

    StorageFile getFileName(ContainerKey identity, boolean stub, boolean errorOK, boolean tryAlternatePath) {
        return this.privGetFileName(identity, stub, errorOK, tryAlternatePath);
    }

    protected StorageFile privGetFileName(ContainerKey identity, boolean stub, boolean errorOK, boolean tryAlternatePath) {
        return this.dataFactory.storageFactory.newStorageFile(this.dataFactory.storageFactory.getTempDir(), "T" + identity.getContainerId() + ".tmp");
    }

    public Page addPage(BaseContainerHandle handle, boolean isOverflow) throws StandardException {
        BasePage newPage = this.newPage(handle, null, handle, isOverflow);
        SanityManager.ASSERT(newPage.isLatched());
        return newPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(BaseContainerHandle handle) throws StandardException {
        TempRAFContainer tempRAFContainer = this;
        synchronized (tempRAFContainer) {
            this.setDroppedState(true);
            this.setCommittedDropState(true);
            this.setDirty(false);
            this.needsSync = false;
        }
        while (!this.pageCache.discard(this.identity)) {
        }
        this.removeFile(this.getFileName(this.identity, false, true, false));
        this.createIdent(this.identity, this);
        this.addPage(handle, false).unlatch();
    }

    protected boolean use(BaseContainerHandle handle, boolean forUpdate, boolean droppedOK) throws StandardException {
        if (super.use(handle, forUpdate, droppedOK)) {
            ++this.inUseCount;
            return true;
        }
        return false;
    }

    protected void letGo(BaseContainerHandle handle) {
        --this.inUseCount;
        super.letGo(handle);
    }

    public boolean isSingleUser() {
        return this.inUseCount == 1;
    }
}

