/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IDataBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBuilderRegistry {
    public static final int TOP_LEVEL_MODE = 0;
    public static final int INSTANCE_LEVEL_MODE = 1;
    protected Map<String, IDataBuilder<?>> dataStructureBuilders = new HashMap();
    private static DataBuilderRegistry topLevelRegistry;
    private static DataBuilderRegistry instanceLevelRegistry;

    public static DataBuilderRegistry getTopLevelRegistry() {
        if (topLevelRegistry == null) {
            topLevelRegistry = new DataBuilderRegistry();
        }
        return topLevelRegistry;
    }

    public static DataBuilderRegistry getInstanceLevelRegistry() {
        if (instanceLevelRegistry == null) {
            instanceLevelRegistry = new DataBuilderRegistry();
        }
        return instanceLevelRegistry;
    }

    public void registerDataStructureBuilder(String id, IDataBuilder<?> dataBuilder) {
        this.dataStructureBuilders.put(id, dataBuilder);
    }

    public void unRegisterDataStructureBuilder(String id) {
        this.dataStructureBuilders.remove(id);
    }

    public Collection<IDataBuilder<?>> getDataStructureBuilders() {
        return this.dataStructureBuilders.values();
    }

    public IDataBuilder<?> getDataStructureBuilder(String id) {
        return this.dataStructureBuilders.get(id);
    }

    public void clear() {
        this.dataStructureBuilders.clear();
    }
}

