/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.provisional.repository.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.cosmos.rm.internal.repository.RepositoryMessages;
import org.eclipse.cosmos.rm.provisional.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.provisional.repository.exception.MissingRepositoryException;
import org.eclipse.osgi.util.NLS;

public abstract class SMLRepositoryFactory {
    private static final String PROPERTIES_FILE_PATH = "/META-INF/sml/repository.properties";
    private static final String PROPERTY_REPOSITORY_CLASS = "org.eclipse.cosmos.rm.repository";

    public static ISMLRepository createRepository() throws MissingRepositoryException {
        Object repository = null;
        String repositoryClass = System.getProperty(PROPERTY_REPOSITORY_CLASS);
        if (repositoryClass != null) {
            repository = SMLRepositoryFactory.createClassInstance(repositoryClass);
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            classLoader = classLoader == null ? SMLRepositoryFactory.class.getClassLoader() : classLoader;
            InputStream propertiesInputStream = classLoader.getResourceAsStream(PROPERTIES_FILE_PATH);
            if (propertiesInputStream != null) {
                Properties properties = new Properties();
                try {
                    properties.load(propertiesInputStream);
                }
                catch (IOException e) {
                    throw new MissingRepositoryException(e.getLocalizedMessage(), e);
                }
                return SMLRepositoryFactory.createRepository(properties);
            }
        }
        if (repository == null) {
            throw new MissingRepositoryException(RepositoryMessages.errorMissingNoImpl);
        }
        if (!(repository instanceof ISMLRepository)) {
            throw new MissingRepositoryException(NLS.bind((String)RepositoryMessages.errorMissingWrongType, (Object[])new String[]{repositoryClass, ISMLRepository.class.getName()}));
        }
        return (ISMLRepository)repository;
    }

    private static Object createClassInstance(String repositoryClass) throws MissingRepositoryException {
        try {
            return Class.forName(repositoryClass).newInstance();
        }
        catch (IllegalAccessException e) {
            throw new MissingRepositoryException(e.getLocalizedMessage(), e);
        }
        catch (InstantiationException e) {
            throw new MissingRepositoryException(e.getLocalizedMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new MissingRepositoryException(e.getLocalizedMessage(), e);
        }
    }

    public static ISMLRepository createRepository(Properties properties) throws MissingRepositoryException {
        if (properties == null) {
            throw new MissingRepositoryException(RepositoryMessages.errorMissingNoImpl);
        }
        String repositoryClassName = properties.getProperty(PROPERTY_REPOSITORY_CLASS);
        if (repositoryClassName == null) {
            throw new MissingRepositoryException(RepositoryMessages.errorMissingNoImpl);
        }
        Object repository = SMLRepositoryFactory.createClassInstance(repositoryClassName);
        if (!(repository instanceof ISMLRepository)) {
            throw new MissingRepositoryException(NLS.bind((String)RepositoryMessages.errorMissingWrongType, (Object[])new String[]{repositoryClassName, ISMLRepository.class.getName()}));
        }
        return (ISMLRepository)repository;
    }
}

