/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tests.common.validation;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cosmos.me.sdd.common.validation.util.ValidatorUtils;
import org.eclipse.cosmos.me.sdd.tests.common.validation.SDDManagerImpl_Test;
import org.eclipse.cosmos.me.sdd.tests.common.validation.SDD_DASImpl_Test;
import org.eclipse.cosmos.me.sdd.tests.common.validation.SchemaValidationRule_Test;
import org.eclipse.cosmos.me.sdd.tests.common.validation.SchematronValidationRule_Test;
import org.eclipse.cosmos.me.sdd.tests.common.validation.XML_DASImpl_Test;

public class AllTests {
    public static final String FSEP = System.getProperty("file.separator");
    public static final String ARTIFACT_LOCATION = "src" + FSEP + "org" + FSEP + "eclipse" + FSEP + "cosmos" + FSEP + "me" + FSEP + "internal" + FSEP + "deployment" + FSEP + "sdd" + FSEP + "tests" + FSEP + "artifacts" + FSEP + "common" + FSEP + "validation";
    public static final String VALID_DD = String.valueOf(ARTIFACT_LOCATION) + FSEP + "Valid_DD_Example.xml";
    public static final String INVALID_DD = String.valueOf(ARTIFACT_LOCATION) + FSEP + "Invalid_DD_Example.xml";
    public static final String VALID_PD = String.valueOf(ARTIFACT_LOCATION) + FSEP + "Valid_PD_Example.xml";
    public static final String INVALID_PD = String.valueOf(ARTIFACT_LOCATION) + FSEP + "Invalid_PD_Example.xml";
    public static final String MALFORMED_DD = String.valueOf(ARTIFACT_LOCATION) + FSEP + "Malformed_DD_Example.xml";
    public static final String NON_SDD_XML = String.valueOf(ARTIFACT_LOCATION) + FSEP + "Non_SDD.xml";
    public static final String DD_SCHEMA = "sdd_schema/sdd-deploymentDescriptor-1.0.xsd";
    public static final String PD_SCHEMA = "sdd_schema/sdd-packageDescriptor-1.0.xsd";
    public static final String COMMON_SCHEMA = "sdd_schema/sdd-common-1.0.xsd";
    public static final String XMLDSIG_SCHEMA = "sdd_schema/xmldsig-core-schema.xsd";

    public static void copySchemaFiles() {
        try {
            FileChannel ddSrcChannel = new FileInputStream(ValidatorUtils.getTempFileFromSchemaName("sdd-deploymentDescriptor-1.0.xsd")).getChannel();
            FileChannel ddDestChannel = new FileOutputStream(DD_SCHEMA).getChannel();
            ddDestChannel.transferFrom(ddSrcChannel, 0L, ddSrcChannel.size());
            FileChannel pdSrcChannel = new FileInputStream(ValidatorUtils.getTempFileFromSchemaName("sdd-packageDescriptor-1.0.xsd")).getChannel();
            FileChannel pdDestChannel = new FileOutputStream(PD_SCHEMA).getChannel();
            pdDestChannel.transferFrom(pdSrcChannel, 0L, pdSrcChannel.size());
            FileChannel commonSrcChannel = new FileInputStream(ValidatorUtils.getTempFileFromSchemaName("sdd-common-1.0.xsd")).getChannel();
            FileChannel commonDestChannel = new FileOutputStream(COMMON_SCHEMA).getChannel();
            commonDestChannel.transferFrom(commonSrcChannel, 0L, commonSrcChannel.size());
            FileChannel xmldsigSrcChannel = new FileInputStream(ValidatorUtils.getTempFileFromSchemaName("xmldsig-core-schema.xsd")).getChannel();
            FileChannel xmldsigDestChannel = new FileOutputStream(XMLDSIG_SCHEMA).getChannel();
            xmldsigDestChannel.transferFrom(xmldsigSrcChannel, 0L, xmldsigSrcChannel.size());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Test for SDD Validator");
        suite.addTestSuite(XML_DASImpl_Test.class);
        suite.addTestSuite(SchemaValidationRule_Test.class);
        suite.addTestSuite(SchematronValidationRule_Test.class);
        suite.addTestSuite(SDDManagerImpl_Test.class);
        suite.addTestSuite(SDD_DASImpl_Test.class);
        return suite;
    }
}

