/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.tests.common.validation;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import junit.framework.TestCase;

import org.eclipse.cosmos.me.sdd.common.validation.SDD_DAS;
import org.eclipse.cosmos.me.sdd.common.validation.exception.XMLValidationException;
import org.eclipse.cosmos.me.sdd.common.validation.plugin.SDD_DASImpl;
import org.w3c.dom.Document;

public class SDD_DASImpl_Test extends TestCase {

	protected void setUp() throws Exception {
		super.setUp();		
		
		AllTests.copySchemaFiles();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	
	/*
	 * Test performing validation
	 */
	public void testValidate_SchemaValid() throws FileNotFoundException, IOException, XMLValidationException {
		SDD_DAS mySddDas = new SDD_DASImpl();
				
		Document doc = mySddDas.loadDocument(new FileInputStream(AllTests.VALID_PD));
		
		assertEquals(mySddDas.validate(doc).size(), 0);
	}
	
	public void testValidate_SchemaInvalid() throws FileNotFoundException, IOException, XMLValidationException {
		SDD_DAS mySddDas = new SDD_DASImpl();
				
		Document doc = mySddDas.loadDocument(new FileInputStream(AllTests.VALID_DD));
		doc.getDocumentElement().removeAttribute("descriptorID");
		
		assertFalse(mySddDas.validate(doc).size() == 0);
	}
	
	public void testValidate_NonSDD() throws FileNotFoundException, IOException, XMLValidationException {
		SDD_DAS mySddDas = new SDD_DASImpl();
		
		Document doc = mySddDas.loadDocument(new FileInputStream(AllTests.NON_SDD_XML));
		
		try {
			mySddDas.validate(doc);
			fail("XML file is not a DD or PD but an IllegalArgumentException was not thrown");
		} catch (IllegalArgumentException e) {
			// This exception is expected
		}		
	}
}
