/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.tooling.btg.sdd.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;

import org.eclipse.cosmos.me.sdd.schema.DeploymentDescriptorType;

public class SDDReader {

	File sddFile = null;
	
	public SDDReader(String sddFileName) {
		sddFile = new File(sddFileName);		
	}
	
	public JAXBElement<DeploymentDescriptorType> getSDDData() throws FileNotFoundException, JAXBException
	{
		// Create an InputStream for the SDD File
		InputStream inputStream = new FileInputStream(sddFile);
		
		// Build a Document from the InputStream
		JAXBElement<DeploymentDescriptorType> xmlDocument = null;
		
		// Create a DocumentBuilder and parse the InputStream into a Document
		
		JAXBContext jc = JAXBContext.newInstance(DeploymentDescriptorType.class);
		Unmarshaller u = jc.createUnmarshaller();
		
		xmlDocument = u.unmarshal(new StreamSource(inputStream), DeploymentDescriptorType.class);
		
		return xmlDocument;
	}
	
}
