/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.provisional.dr.drs.service.handler.common;

import java.util.Map;

/**
 * Provides a list of name value map that is used by outputters as input 
 * parameters.
 */
public interface IParameters {
	/**
	 * Returns a parameter value with an associated key name
	 * @param name - key name
	 * @return value of the parameter
	 */
	public String getParameter(String name);

	public Map getParameterMap();
}
