/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.EngineStatement;
import org.apache.derby.impl.jdbc.Util;

public class BrokeredStatement
implements EngineStatement {
    final BrokeredStatementControl control;
    final int resultSetType;
    final int resultSetConcurrency;
    final int resultSetHoldability;
    private String cursorName;
    private Boolean escapeProcessing;

    BrokeredStatement(BrokeredStatementControl control) throws SQLException {
        this.control = control;
        this.resultSetType = this.getResultSetType();
        this.resultSetConcurrency = this.getResultSetConcurrency();
        this.resultSetHoldability = this.getResultSetHoldability();
    }

    public final void addBatch(String sql) throws SQLException {
        this.getStatement().addBatch(sql);
    }

    public final void clearBatch() throws SQLException {
        this.getStatement().clearBatch();
    }

    public final int[] executeBatch() throws SQLException {
        return this.getStatement().executeBatch();
    }

    public final void cancel() throws SQLException {
        this.getStatement().cancel();
    }

    public final boolean execute(String sql) throws SQLException {
        return this.getStatement().execute(sql);
    }

    public final ResultSet executeQuery(String sql) throws SQLException {
        return this.wrapResultSet(this.getStatement().executeQuery(sql));
    }

    public final int executeUpdate(String sql) throws SQLException {
        return this.getStatement().executeUpdate(sql);
    }

    public final void close() throws SQLException {
        this.getStatement().close();
    }

    public final Connection getConnection() throws SQLException {
        return this.getStatement().getConnection();
    }

    public final int getFetchDirection() throws SQLException {
        return this.getStatement().getFetchDirection();
    }

    public final int getFetchSize() throws SQLException {
        return this.getStatement().getFetchSize();
    }

    public final int getMaxFieldSize() throws SQLException {
        return this.getStatement().getMaxFieldSize();
    }

    public final int getMaxRows() throws SQLException {
        return this.getStatement().getMaxRows();
    }

    public final int getResultSetConcurrency() throws SQLException {
        return this.getStatement().getResultSetConcurrency();
    }

    public final void setMaxFieldSize(int max) throws SQLException {
        this.getStatement().setMaxFieldSize(max);
    }

    public final void setMaxRows(int max) throws SQLException {
        this.getStatement().setMaxRows(max);
    }

    public final void setEscapeProcessing(boolean enable) throws SQLException {
        this.getStatement().setEscapeProcessing(enable);
        this.escapeProcessing = enable ? Boolean.TRUE : Boolean.FALSE;
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.getStatement().getWarnings();
    }

    public final void clearWarnings() throws SQLException {
        this.getStatement().clearWarnings();
    }

    public final void setCursorName(String name) throws SQLException {
        this.getStatement().setCursorName(name);
        this.cursorName = name;
    }

    public final ResultSet getResultSet() throws SQLException {
        return this.wrapResultSet(this.getStatement().getResultSet());
    }

    public final int getUpdateCount() throws SQLException {
        return this.getStatement().getUpdateCount();
    }

    public final boolean getMoreResults() throws SQLException {
        return this.getStatement().getMoreResults();
    }

    public final int getResultSetType() throws SQLException {
        return this.getStatement().getResultSetType();
    }

    public final void setFetchDirection(int direction) throws SQLException {
        this.getStatement().setFetchDirection(direction);
    }

    public final void setFetchSize(int rows) throws SQLException {
        this.getStatement().setFetchSize(rows);
    }

    public final int getQueryTimeout() throws SQLException {
        return this.getStatement().getQueryTimeout();
    }

    public final void setQueryTimeout(int seconds) throws SQLException {
        this.getStatement().setQueryTimeout(seconds);
    }

    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.getStatement().execute(sql, autoGeneratedKeys);
    }

    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.getStatement().execute(sql, columnIndexes);
    }

    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.getStatement().execute(sql, columnNames);
    }

    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int retVal = this.getStatement().executeUpdate(sql, autoGeneratedKeys);
        return retVal;
    }

    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.getStatement().executeUpdate(sql, columnIndexes);
    }

    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.getStatement().executeUpdate(sql, columnNames);
    }

    public final boolean getMoreResults(int current) throws SQLException {
        return ((EngineStatement)this.getStatement()).getMoreResults(current);
    }

    public final ResultSet getGeneratedKeys() throws SQLException {
        return this.wrapResultSet(this.getStatement().getGeneratedKeys());
    }

    public final int getResultSetHoldability() throws SQLException {
        int holdability = ((EngineStatement)this.getStatement()).getResultSetHoldability();
        return this.controlCheck().checkHoldCursors(holdability);
    }

    public Statement createDuplicateStatement(Connection conn, Statement oldStatement) throws SQLException {
        Statement newStatement = conn.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        this.setStatementState(oldStatement, newStatement);
        return newStatement;
    }

    void setStatementState(Statement oldStatement, Statement newStatement) throws SQLException {
        if (this.cursorName != null) {
            newStatement.setCursorName(this.cursorName);
        }
        if (this.escapeProcessing != null) {
            newStatement.setEscapeProcessing(this.escapeProcessing);
        }
        newStatement.setFetchDirection(oldStatement.getFetchDirection());
        newStatement.setFetchSize(oldStatement.getFetchSize());
        newStatement.setMaxFieldSize(oldStatement.getMaxFieldSize());
        newStatement.setMaxRows(oldStatement.getMaxRows());
        newStatement.setQueryTimeout(oldStatement.getQueryTimeout());
    }

    public Statement getStatement() throws SQLException {
        return this.control.getRealStatement();
    }

    final ResultSet wrapResultSet(ResultSet rs) {
        return this.control.wrapResultSet(this, rs);
    }

    final BrokeredStatementControl controlCheck() throws SQLException {
        this.getStatement().getConnection();
        return this.control;
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        this.checkIfClosed();
        return iface.isInstance(this);
    }

    protected boolean isClosed() throws SQLException {
        throw Util.notImplemented();
    }

    protected final void checkIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw Util.generateCsSQLException("XJ012.S", "Statement");
        }
    }
}

