/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.Reader;
import org.apache.derby.iapi.services.io.Limit;

public final class LimitReader
extends Reader
implements Limit {
    private int remainingCharacters;
    private boolean limitInPlace;
    private Reader reader;

    public LimitReader(Reader reader) {
        this.reader = reader;
        this.clearLimit();
    }

    public int read() throws IOException {
        if (!this.limitInPlace) {
            return this.reader.read();
        }
        if (this.remainingCharacters == 0) {
            return -1;
        }
        int value = this.reader.read();
        if (value >= 0) {
            --this.remainingCharacters;
        }
        return value;
    }

    public int read(char[] c, int off, int len) throws IOException {
        if (!this.limitInPlace) {
            return this.reader.read(c, off, len);
        }
        if (this.remainingCharacters == 0) {
            return -1;
        }
        if (this.remainingCharacters < len) {
            len = this.remainingCharacters;
        }
        if ((len = this.reader.read(c, off, len)) >= 0) {
            this.remainingCharacters -= len;
        }
        return len;
    }

    public long skip(long count) throws IOException {
        if (!this.limitInPlace) {
            return this.reader.skip(count);
        }
        if (this.remainingCharacters == 0) {
            return 0L;
        }
        if ((long)this.remainingCharacters < count) {
            count = this.remainingCharacters;
        }
        count = this.reader.skip(count);
        this.remainingCharacters = (int)((long)this.remainingCharacters - count);
        return count;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public void setLimit(int length) {
        this.remainingCharacters = length;
        this.limitInPlace = true;
    }

    public final int getLimit() {
        return this.remainingCharacters;
    }

    public int clearLimit() {
        int leftOver = this.remainingCharacters;
        this.limitInPlace = false;
        this.remainingCharacters = -1;
        return leftOver;
    }
}

