/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.security.AccessControlException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.SQLWarningFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.memory.LowMemory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.impl.db.SlaveDatabase;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.EmbedConnectionContext;
import org.apache.derby.impl.jdbc.LOBFile;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.jdbc.authentication.NoneAuthenticationServiceImpl;
import org.apache.derby.jdbc.InternalDriver;
import org.apache.derby.security.DatabasePermission;

public abstract class EmbedConnection
implements EngineConnection {
    private static final StandardException exceptionClose = StandardException.closeException();
    public static final SQLException NO_MEM = Util.generateCsSQLException("08004", "java.lang.OutOfMemoryError");
    public static final LowMemory memoryState = new LowMemory();
    DatabaseMetaData dbMetadata;
    TransactionResourceImpl tr;
    private HashMap lobHashMap = null;
    private int lobHMKey = 0;
    private WeakHashMap lobReferences = null;
    private HashSet lobFiles;
    private boolean active;
    boolean autoCommit = true;
    boolean needCommit;
    private boolean usingNoneAuth;
    private int connectionHoldAbility = 1;
    final EmbedConnection rootConnection;
    private SQLWarning topWarning;
    private InternalDriver factory;
    private Connection applicationConnection;
    private int resultSetId;
    private String connString;
    private static final int OP_ENCRYPT = 0;
    private static final int OP_SHUTDOWN = 1;
    private static final int OP_HARD_UPGRADE = 2;
    private static final int OP_REPLICATION = 3;

    public EmbedConnection(InternalDriver driver, String url, Properties info) throws SQLException {
        this.rootConnection = this;
        this.applicationConnection = this.rootConnection;
        this.factory = driver;
        this.tr = new TransactionResourceImpl(driver, url, info);
        this.active = true;
        this.setupContextStack();
        try {
            EmbedConnectionContext context = this.pushConnectionContext(this.tr.getContextManager());
            boolean shutdown = Boolean.valueOf(info.getProperty("shutdown"));
            Database database = (Database)Monitor.findService("org.apache.derby.database.Database", this.tr.getDBName());
            boolean createBoot = this.createBoot(info);
            boolean isTwoPhaseEncryptionBoot = !createBoot && this.isEncryptionBoot(info);
            boolean isTwoPhaseUpgradeBoot = !createBoot && this.isHardUpgradeBoot(info);
            boolean isStartSlaveBoot = this.isStartReplicationSlaveBoot(info);
            boolean slaveDBAlreadyBooted = false;
            boolean isFailoverMasterBoot = false;
            boolean isFailoverSlaveBoot = false;
            String replicationOp = this.getReplicationOperation(info);
            if (replicationOp != null && (createBoot || shutdown || isTwoPhaseEncryptionBoot || isTwoPhaseUpgradeBoot)) {
                throw StandardException.newException("XRE10", replicationOp);
            }
            if (this.isReplicationFailover(info)) {
                this.checkDatabaseBooted(database, "failover", this.tr.getDBName());
                if (database.isInSlaveMode()) {
                    isFailoverSlaveBoot = true;
                } else {
                    isFailoverMasterBoot = true;
                }
            }
            Properties savedInfo = null;
            if (isStartSlaveBoot) {
                if (database != null) {
                    slaveDBAlreadyBooted = true;
                } else {
                    info.setProperty("replication.slave.mode", "slavepremode");
                }
            }
            if (this.isStopReplicationSlaveBoot(info)) {
                this.handleStopReplicationSlave(database, info);
            } else {
                if (this.isInternalShutdownSlaveDatabase(info)) {
                    this.internalStopReplicationSlave(database, info);
                    return;
                }
                if (isFailoverSlaveBoot) {
                    this.handleFailoverSlave(database);
                }
            }
            if (database != null) {
                this.tr.setDatabase(database);
                isTwoPhaseEncryptionBoot = false;
                isTwoPhaseUpgradeBoot = false;
            } else if (!shutdown) {
                if (isTwoPhaseEncryptionBoot || isTwoPhaseUpgradeBoot) {
                    savedInfo = info;
                    info = this.removePhaseTwoProps((Properties)info.clone());
                }
                if (!this.bootDatabase(info, isTwoPhaseUpgradeBoot)) {
                    this.tr.clearContextInError();
                    this.setInactive();
                    return;
                }
            }
            if (createBoot && !shutdown) {
                if (this.tr.getDatabase() != null) {
                    this.addWarning(SQLWarningFactory.newSQLWarning("01J01", this.getDBName()));
                } else {
                    this.checkUserCredentials(null, info);
                    database = this.createDatabase(this.tr.getDBName(), info);
                    this.tr.setDatabase(database);
                }
            }
            if (this.tr.getDatabase() == null) {
                this.handleDBNotFound();
            }
            try {
                this.checkUserCredentials(this.tr.getDBName(), info);
            }
            catch (SQLException sqle) {
                if (isStartSlaveBoot && !slaveDBAlreadyBooted) {
                    this.tr.startTransaction();
                    this.handleException(this.tr.shutdownDatabaseException());
                }
                throw sqle;
            }
            this.tr.startTransaction();
            if (this.isStartReplicationMasterBoot(info) || this.isStopReplicationMasterBoot(info) || isFailoverMasterBoot) {
                if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                    this.checkIsDBOwner(3);
                }
                if (this.isStartReplicationMasterBoot(info)) {
                    this.handleStartReplicationMaster(this.tr, info);
                } else if (this.isStopReplicationMasterBoot(info)) {
                    this.handleStopReplicationMaster(this.tr, info);
                } else if (isFailoverMasterBoot) {
                    this.handleFailoverMaster(this.tr);
                }
            }
            if (isTwoPhaseEncryptionBoot || isTwoPhaseUpgradeBoot || isStartSlaveBoot) {
                if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                    int operation = isTwoPhaseEncryptionBoot ? 0 : (isTwoPhaseUpgradeBoot ? 2 : 3);
                    try {
                        this.checkIsDBOwner(operation);
                    }
                    catch (SQLException sqle) {
                        if (isStartSlaveBoot) {
                            this.handleException(this.tr.shutdownDatabaseException());
                        }
                        throw sqle;
                    }
                }
                if (isStartSlaveBoot) {
                    if (slaveDBAlreadyBooted) {
                        throw StandardException.newException("XRE09", this.getTR().getDBName());
                    }
                    info.setProperty("replication.slave.mode", "slavemode");
                    info.setProperty("replication.slave.dbname", this.getTR().getDBName());
                } else {
                    info = savedInfo;
                }
                this.handleException(this.tr.shutdownDatabaseException());
                this.restoreContextStack();
                this.tr = new TransactionResourceImpl(driver, url, info);
                this.active = true;
                this.setupContextStack();
                context = this.pushConnectionContext(this.tr.getContextManager());
                if (!this.bootDatabase(info, false)) {
                    SanityManager.THROWASSERT("bootDatabase failed after initial plain boot for (re)encryption or upgrade");
                    this.tr.clearContextInError();
                    this.setInactive();
                    return;
                }
                if (isStartSlaveBoot) {
                    throw StandardException.newException("XRE08", this.getTR().getDBName());
                }
                this.tr.startTransaction();
            }
            if (shutdown) {
                if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                    this.checkIsDBOwner(1);
                }
                throw this.tr.shutdownDatabaseException();
            }
            if (this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                this.addWarning(SQLWarningFactory.newSQLWarning("01J14"));
            }
        }
        catch (OutOfMemoryError noMemory) {
            this.restoreContextStack();
            this.tr.lcc = null;
            this.tr.cm = null;
            memoryState.setLowMemory();
            throw NO_MEM;
        }
        catch (Throwable t) {
            StandardException se;
            if (t instanceof StandardException && (se = (StandardException)t).getSeverity() < 40000) {
                se.setSeverity(40000);
            }
            this.tr.cleanupOnError(t);
            throw this.handleException(t);
        }
        finally {
            this.restoreContextStack();
        }
    }

    private void checkDatabaseBooted(Database database, String operation, String dbname) throws SQLException {
        if (database == null) {
            this.setInactive();
            throw this.newSQLException("XRE11", operation, dbname);
        }
    }

    private boolean createBoot(Properties p) throws SQLException {
        int createCount = 0;
        if (Boolean.valueOf(p.getProperty("create")).booleanValue()) {
            ++createCount;
        }
        int restoreCount = 0;
        if (p.getProperty("createFrom") != null) {
            ++restoreCount;
        }
        if (p.getProperty("restoreFrom") != null) {
            ++restoreCount;
        }
        if (p.getProperty("rollForwardRecoveryFrom") != null) {
            ++restoreCount;
        }
        if (restoreCount > 1) {
            throw this.newSQLException("XJ081.C");
        }
        if (restoreCount != 0 && this.isEncryptionBoot(p)) {
            throw this.newSQLException("XJ081.C");
        }
        if ((createCount += restoreCount) > 1) {
            throw this.newSQLException("XJ049.C");
        }
        return createCount - restoreCount == 1;
    }

    private void handleDBNotFound() throws SQLException {
        String dbname = this.tr.getDBName();
        this.setInactive();
        throw this.newSQLException("XJ004.C", dbname);
    }

    private boolean isEncryptionBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("dataEncryption")) != false || p.getProperty("newBootPassword") != null || p.getProperty("newEncryptionKey") != null;
    }

    private boolean isHardUpgradeBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("upgrade"));
    }

    private boolean isStartReplicationSlaveBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("startSlave"));
    }

    private boolean isStartReplicationMasterBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("startMaster"));
    }

    private boolean isReplicationFailover(Properties p) {
        return Boolean.valueOf(p.getProperty("failover"));
    }

    private boolean isStopReplicationMasterBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("stopMaster"));
    }

    private boolean isStopReplicationSlaveBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("stopSlave"));
    }

    private boolean isInternalShutdownSlaveDatabase(Properties p) {
        return Boolean.valueOf(p.getProperty("internal_stopslave"));
    }

    private String getReplicationOperation(Properties p) throws StandardException {
        String operation = null;
        int opcount = 0;
        if (this.isStartReplicationSlaveBoot(p)) {
            operation = "startSlave";
            ++opcount;
        }
        if (this.isStartReplicationMasterBoot(p)) {
            operation = "startMaster";
            ++opcount;
        }
        if (this.isStopReplicationSlaveBoot(p)) {
            operation = "stopSlave";
            ++opcount;
        }
        if (this.isInternalShutdownSlaveDatabase(p)) {
            operation = "internal_stopslave";
            ++opcount;
        }
        if (this.isStopReplicationMasterBoot(p)) {
            operation = "stopMaster";
            ++opcount;
        }
        if (this.isReplicationFailover(p)) {
            operation = "failover";
            ++opcount;
        }
        if (opcount > 1) {
            throw StandardException.newException("XRE10", operation);
        }
        return operation;
    }

    private void handleStartReplicationMaster(TransactionResourceImpl tr, Properties p) throws SQLException {
        String slavehost;
        if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
            this.checkIsDBOwner(3);
        }
        if ((slavehost = p.getProperty("slaveHost")) == null) {
            SQLException wrappedExc = this.newSQLException("XCY03.S", "slaveHost");
            throw this.newSQLException("08004", wrappedExc);
        }
        String portString = p.getProperty("slavePort");
        int slaveport = -1;
        if (portString != null) {
            slaveport = Integer.valueOf(portString);
        }
        tr.getDatabase().startReplicationMaster(this.getTR().getDBName(), slavehost, slaveport, "derby.__rt.asynch");
    }

    private void handleStopReplicationMaster(TransactionResourceImpl tr, Properties p) throws SQLException {
        if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
            this.checkIsDBOwner(3);
        }
        tr.getDatabase().stopReplicationMaster();
    }

    private void handleStopReplicationSlave(Database database, Properties p) throws StandardException, SQLException {
        this.checkDatabaseBooted(database, "stopSlave", this.tr.getDBName());
        database.stopReplicationSlave();
        throw this.newSQLException("XRE42", this.getTR().getDBName());
    }

    private void internalStopReplicationSlave(Database database, Properties p) throws StandardException, SQLException {
        this.checkDatabaseBooted(database, "internal_stopslave", this.tr.getDBName());
        if (!(database instanceof SlaveDatabase)) {
            throw this.newSQLException("XRE40");
        }
        ((SlaveDatabase)database).verifyShutdownSlave();
        this.handleException(this.tr.shutdownDatabaseException());
    }

    private void handleFailoverMaster(TransactionResourceImpl tr) throws SQLException, StandardException {
        if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
            this.checkIsDBOwner(3);
        }
        tr.getDatabase().failover(tr.getDBName());
    }

    private void handleFailoverSlave(Database database) throws SQLException {
        try {
            database.failover(this.getTR().getDBName());
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    private Properties removePhaseTwoProps(Properties p) {
        p.remove("dataEncryption");
        p.remove("newBootPassword");
        p.remove("newEncryptionKey");
        p.remove("upgrade");
        return p;
    }

    public EmbedConnection(EmbedConnection inputConnection) {
        SanityManager.ASSERT(inputConnection.active, "trying to create a proxy for an inactive conneciton");
        this.autoCommit = false;
        this.tr = null;
        this.active = true;
        this.rootConnection = inputConnection.rootConnection;
        this.applicationConnection = this;
        this.factory = inputConnection.factory;
        this.connectionHoldAbility = inputConnection.connectionHoldAbility;
    }

    private void checkUserCredentials(String dbname, Properties userInfo) throws SQLException {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        AuthenticationService authenticationService = null;
        try {
            authenticationService = dbname == null ? this.getLocalDriver().getAuthenticationService() : this.getTR().getDatabase().getAuthenticationService();
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
        if (authenticationService == null) {
            String failedString = MessageService.getTextMessage(dbname == null ? "A001" : "A002");
            throw this.newSQLException("08004", failedString);
        }
        if (dbname != null) {
            this.checkUserIsNotARole();
        }
        if (!authenticationService.authenticate(dbname, userInfo)) {
            throw this.newSQLException("08004.C.1", MessageService.getTextMessage("A020"));
        }
        if (authenticationService instanceof NoneAuthenticationServiceImpl) {
            this.usingNoneAuth = true;
        }
    }

    private void checkUserIsNotARole() throws SQLException {
        TransactionResourceImpl tr = this.getTR();
        try {
            tr.startTransaction();
            LanguageConnectionContext lcc = tr.getLcc();
            String username = lcc.getAuthorizationId();
            DataDictionary dd = lcc.getDataDictionary();
            if (lcc.usesSqlAuthorization() && dd.checkVersion(160, null)) {
                TransactionController tc = lcc.getTransactionExecute();
                String failedString = MessageService.getTextMessage("A020");
                if (dd.getRoleDefinitionDescriptor(username) != null) {
                    throw this.newSQLException("08004.C.1", failedString);
                }
            }
            tr.rollback();
        }
        catch (StandardException e) {
            try {
                tr.rollback();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            throw this.handleException(e);
        }
    }

    private void checkIsDBOwner(int operation) throws SQLException {
        String dbOwnerId;
        LanguageConnectionContext lcc = this.getLanguageConnection();
        String actualId = lcc.getAuthorizationId();
        if (!actualId.equals(dbOwnerId = lcc.getDataDictionary().getAuthorizationDatabaseOwner())) {
            switch (operation) {
                case 0: {
                    throw this.newSQLException("08004.C.5", actualId, this.tr.getDBName());
                }
                case 1: {
                    throw this.newSQLException("08004.C.4", actualId, this.tr.getDBName());
                }
                case 2: {
                    throw this.newSQLException("08004.C.6", actualId, this.tr.getDBName());
                }
                case 3: {
                    throw this.newSQLException("08004.C.8", actualId, this.tr.getDBName());
                }
            }
            SanityManager.THROWASSERT("illegal checkIsDBOwner operation");
            throw this.newSQLException("08004.C.3");
        }
    }

    public int getEngineType() {
        Database db = this.getDatabase();
        if (null == db) {
            return 0;
        }
        return db.getEngineType();
    }

    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.connectionHoldAbility);
    }

    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.connectionHoldAbility);
    }

    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIfClosed();
        return this.factory.newEmbedStatement(this, false, this.setResultSetType(resultSetType), resultSetConcurrency, resultSetHoldability);
    }

    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, 2, null, null);
    }

    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.connectionHoldAbility, 2, null, null);
    }

    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null);
    }

    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, columnIndexes == null || columnIndexes.length == 0 ? 2 : 1, columnIndexes, null);
    }

    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, columnNames == null || columnNames.length == 0 ? 2 : 1, null, columnNames);
    }

    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, autoGeneratedKeys, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            PreparedStatement preparedStatement;
            this.setupContextStack();
            try {
                preparedStatement = this.factory.newEmbedPreparedStatement(this, sql, false, this.setResultSetType(resultSetType), resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, columnIndexes, columnNames);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return preparedStatement;
        }
    }

    public final CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, this.connectionHoldAbility);
    }

    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.connectionHoldAbility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIfClosed();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            CallableStatement callableStatement;
            this.setupContextStack();
            try {
                callableStatement = this.factory.newEmbedCallableStatement(this, sql, this.setResultSetType(resultSetType), resultSetConcurrency, resultSetHoldability);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return callableStatement;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkIfClosed();
        return sql;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkIfClosed();
        if (this.rootConnection != this && autoCommit) {
            throw this.newSQLException("XJ030.S");
        }
        if (this.autoCommit != autoCommit) {
            this.commit();
        }
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkIfClosed();
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getTR().commit();
                this.clearLOBMapping();
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getTR().rollback();
                this.clearLOBMapping();
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
    }

    public void close() throws SQLException {
        this.checkForTransactionInProgress();
        this.close(exceptionClose);
    }

    public void checkForTransactionInProgress() throws SQLException {
        if (!(this.isClosed() || this.rootConnection != this || this.autoCommit || this.transactionIsIdle())) {
            throw this.newSQLException("25001");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(StandardException e) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.rootConnection == this && this.active) {
                if (this.tr.isActive()) {
                    this.setupContextStack();
                    try {
                        this.tr.rollback();
                        this.tr.clearLcc();
                        this.tr.cleanupOnError(e);
                    }
                    catch (Throwable t) {
                        throw this.handleException(t);
                    }
                    finally {
                        this.restoreContextStack();
                    }
                } else {
                    this.tr.clearLcc();
                    this.tr.cleanupOnError(e);
                }
            }
            if (!this.isClosed()) {
                this.setInactive();
            }
        }
    }

    public final boolean isClosed() {
        return !this.active || !this.getTR().isActive();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIfClosed();
        if (this.dbMetadata == null) {
            this.dbMetadata = this.factory.newEmbedDatabaseMetaData(this, this.getTR().getUrl());
        }
        return this.dbMetadata;
    }

    public final int getHoldability() throws SQLException {
        this.checkIfClosed();
        return this.connectionHoldAbility;
    }

    public final void setHoldability(int holdability) throws SQLException {
        this.checkIfClosed();
        this.connectionHoldAbility = holdability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setReadOnly(boolean readOnly) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().setReadOnly(readOnly);
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final boolean isReadOnly() throws SQLException {
        this.checkIfClosed();
        return this.getLanguageConnection().isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkIfClosed();
    }

    public String getCatalog() throws SQLException {
        this.checkIfClosed();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionIsolation(int level) throws SQLException {
        int iLevel;
        if (level == this.getTransactionIsolation()) {
            return;
        }
        switch (level) {
            case 1: {
                iLevel = 1;
                break;
            }
            case 2: {
                iLevel = 2;
                break;
            }
            case 4: {
                iLevel = 3;
                break;
            }
            case 8: {
                iLevel = 4;
                break;
            }
            default: {
                throw this.newSQLException("XJ045.S", new Integer(level));
            }
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().setIsolationLevel(iLevel);
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final int getTransactionIsolation() throws SQLException {
        this.checkIfClosed();
        return ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[this.getLanguageConnection().getCurrentIsolationLevel()];
    }

    public final synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed();
        return this.topWarning;
    }

    public final synchronized void clearWarnings() throws SQLException {
        this.checkIfClosed();
        this.topWarning = null;
    }

    public Map getTypeMap() throws SQLException {
        this.checkIfClosed();
        return Collections.EMPTY_MAP;
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.checkIfClosed();
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.Connection.setTypeMap");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
    }

    public final synchronized void addWarning(SQLWarning newWarning) {
        if (this.topWarning == null) {
            this.topWarning = newWarning;
            return;
        }
        this.topWarning.setNextWarning(newWarning);
    }

    public String getDBName() {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getDBName();
    }

    public final LanguageConnectionContext getLanguageConnection() {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getLcc();
    }

    protected final void checkIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw Util.noCurrentConnection();
        }
    }

    SQLException handleException(Throwable thrownException) throws SQLException {
        if (thrownException instanceof StandardException && ((StandardException)thrownException).getSeverity() >= 30000) {
            this.clearLOBMapping();
        }
        return this.getTR().handleException(thrownException, this.autoCommit, true);
    }

    final SQLException handleException(Throwable thrownException, boolean rollbackOnAutoCommit) throws SQLException {
        if (thrownException instanceof StandardException && ((StandardException)thrownException).getSeverity() >= 30000) {
            this.clearLOBMapping();
        }
        return this.getTR().handleException(thrownException, this.autoCommit, rollbackOnAutoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInactive() {
        if (!this.active) {
            return;
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.active = false;
            this.dbMetadata = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.rootConnection == this) {
                this.close(exceptionClose);
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void needCommit() {
        if (!this.needCommit) {
            this.needCommit = true;
        }
    }

    protected void commitIfNeeded() throws SQLException {
        if (this.autoCommit && this.needCommit) {
            try {
                this.getTR().commit();
                this.clearLOBMapping();
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            this.needCommit = false;
        }
    }

    protected void commitIfAutoCommit() throws SQLException {
        if (this.autoCommit) {
            try {
                this.getTR().commit();
                this.clearLOBMapping();
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            this.needCommit = false;
        }
    }

    protected final Object getConnectionSynchronization() {
        return this.rootConnection;
    }

    protected final void setupContextStack() throws SQLException {
        this.checkIfClosed();
        this.getTR().setupContextStack();
    }

    protected final void restoreContextStack() throws SQLException {
        Util.ASSERT(this, this.active || this.getTR().getCsf() != null, "No context service to do restore");
        TransactionResourceImpl tr = this.getTR();
        if (tr.getCsf() != null) {
            ContextManager cm2;
            ContextManager cm1 = tr.getCsf().getCurrentContextManager();
            Util.ASSERT(this, cm1 == (cm2 = tr.getContextManager()) || cm1 == null, "Current Context Manager not the one was expected: " + cm1 + " " + cm2);
        }
        tr.restoreContextStack();
    }

    private Database createDatabase(String dbname, Properties info) throws SQLException {
        info = this.filterProperties(info);
        try {
            if (Monitor.createPersistentService("org.apache.derby.database.Database", dbname, info) == null) {
                this.addWarning(SQLWarningFactory.newSQLWarning("01J01", dbname));
            }
        }
        catch (StandardException mse) {
            throw Util.seeNextException("XJ041.C", new Object[]{dbname}, this.handleException(mse));
        }
        info.clear();
        return (Database)Monitor.findService("org.apache.derby.database.Database", dbname);
    }

    private void checkDatabaseCreatePrivileges(String user, String dbname) throws SQLException {
        if (System.getSecurityManager() == null) {
            return;
        }
        if (dbname == null) {
            throw new NullPointerException("dbname can't be null");
        }
        try {
            String url = "directory:" + EmbedConnection.stripSubSubProtocolPrefix(dbname);
            DatabasePermission dp = new DatabasePermission(url, "create");
            this.factory.checkSystemPrivileges(user, dp);
        }
        catch (AccessControlException ace) {
            throw Util.generateCsSQLException("08004.C.11", user, dbname, ace);
        }
        catch (IOException ioe) {
            throw Util.generateCsSQLException("08004.C.10", (Object)dbname, (Object)ioe);
        }
        catch (Exception e) {
            throw Util.generateCsSQLException("08004.C.10", (Object)dbname, (Object)e);
        }
    }

    public static String stripSubSubProtocolPrefix(String dbname) {
        String prop;
        int i = dbname.indexOf(58);
        if (i > 0 && PropertyUtil.getSystemProperty(prop = "derby.subSubProtocol." + dbname.substring(0, i), null) != null) {
            return dbname.substring(i + 1);
        }
        return dbname;
    }

    private boolean bootDatabase(Properties info, boolean softAuthenticationBoot) throws Throwable {
        String dbname = this.tr.getDBName();
        try {
            info = this.filterProperties(info);
            if (softAuthenticationBoot) {
                info.setProperty("softUpgradeNoFeatureCheck", "true");
            } else {
                info.remove("softUpgradeNoFeatureCheck");
            }
            if (!Monitor.startPersistentService(dbname, info)) {
                return false;
            }
            info.clear();
            Database database = (Database)Monitor.findService("org.apache.derby.database.Database", dbname);
            this.tr.setDatabase(database);
        }
        catch (StandardException mse) {
            Throwable ne = mse.getCause();
            SQLException nse = ne instanceof StandardException ? Util.generateCsSQLException((StandardException)ne) : (ne != null ? Util.javaException(ne) : Util.generateCsSQLException(mse));
            throw Util.seeNextException("XJ040.C", new Object[]{dbname}, nse);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreparedStatement prepareMetaDataStatement(String sql) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            PreparedStatement s = null;
            try {
                s = this.factory.newEmbedPreparedStatement(this, sql, true, 1003, 1007, this.connectionHoldAbility, 2, null, null);
            }
            finally {
                this.restoreContextStack();
            }
            return s;
        }
    }

    public final InternalDriver getLocalDriver() {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getDriver();
    }

    public final ContextManager getContextManager() {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getContextManager();
    }

    private Properties filterProperties(Properties inputSet) {
        Properties limited = new Properties();
        Enumeration<?> e = inputSet.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("derby.")) continue;
            limited.put(key, inputSet.getProperty(key));
        }
        return limited;
    }

    protected Database getDatabase() {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getDatabase();
    }

    protected final TransactionResourceImpl getTR() {
        return this.rootConnection.tr;
    }

    private EmbedConnectionContext pushConnectionContext(ContextManager cm) {
        return new EmbedConnectionContext(cm, this);
    }

    public final void setApplicationConnection(Connection applicationConnection) {
        this.applicationConnection = applicationConnection;
    }

    public final Connection getApplicationConnection() {
        return this.applicationConnection;
    }

    public void setDrdaID(String drdaID) {
        this.getLanguageConnection().setDrdaID(drdaID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFromPool() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().resetFromPool();
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int xa_prepare() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                XATransactionController tc = (XATransactionController)this.getLanguageConnection().getTransactionExecute();
                int ret = tc.xa_prepare();
                if (ret == 1) {
                    this.getLanguageConnection().internalCommit(false);
                }
                int n = ret;
                return n;
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_commit(boolean onePhase) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().xaCommit(onePhase);
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_rollback() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().xaRollback();
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final boolean transactionIsIdle() {
        return this.getTR().isIdle();
    }

    private int setResultSetType(int resultSetType) {
        if (resultSetType == 1005) {
            this.addWarning(SQLWarningFactory.newSQLWarning("01J02"));
            resultSetType = 1004;
        }
        return resultSetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrepareIsolation(int level) throws SQLException {
        if (level == this.getPrepareIsolation()) {
            return;
        }
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw Util.generateCsSQLException("XJ045.S", new Integer(level));
            }
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.getLanguageConnection().setPrepareIsolationLevel(level);
        }
    }

    public int getPrepareIsolation() {
        return this.getLanguageConnection().getPrepareIsolationLevel();
    }

    final int getResultSetOrderId() {
        if (this == this.rootConnection) {
            return 0;
        }
        return this.rootConnection.resultSetId++;
    }

    protected SQLException newSQLException(String messageId) {
        return Util.generateCsSQLException(messageId);
    }

    protected SQLException newSQLException(String messageId, Object arg1) {
        return Util.generateCsSQLException(messageId, arg1);
    }

    protected SQLException newSQLException(String messageId, Object arg1, Object arg2) {
        return Util.generateCsSQLException(messageId, arg1, arg2);
    }

    public String toString() {
        if (this.connString == null) {
            LanguageConnectionContext lcc = this.getLanguageConnection();
            this.connString = this.getClass().getName() + "@" + this.hashCode() + " " + "(XID = " + lcc.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + Integer.toString(lcc.getInstanceNumber()) + "), " + "(DATABASE = " + lcc.getDbname() + "), " + "(DRDAID = " + lcc.getDrdaID() + ") ";
        }
        return this.connString;
    }

    public Clob createClob() throws SQLException {
        this.checkIfClosed();
        return new EmbedClob(this);
    }

    public Blob createBlob() throws SQLException {
        this.checkIfClosed();
        return new EmbedBlob(new byte[0], this);
    }

    public int addLOBMapping(Object LOBReference) {
        int loc = this.getIncLOBKey();
        this.getlobHMObj().put(new Integer(loc), LOBReference);
        return loc;
    }

    public void removeLOBMapping(int key) {
        this.getlobHMObj().remove(new Integer(key));
    }

    public Object getLOBMapping(int key) {
        return this.getlobHMObj().get(new Integer(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLOBMapping() throws SQLException {
        WeakHashMap map = this.rootConnection.lobReferences;
        if (map != null) {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                ((EngineLOB)it.next()).free();
            }
            map.clear();
        }
        if (this.rootConnection.lobHashMap != null) {
            this.rootConnection.lobHashMap.clear();
        }
        EmbedConnection embedConnection = this;
        synchronized (embedConnection) {
            if (this.lobFiles != null) {
                Iterator it = this.lobFiles.iterator();
                while (it.hasNext()) {
                    try {
                        ((LOBFile)it.next()).close();
                    }
                    catch (IOException ioe) {
                        throw Util.javaException(ioe);
                    }
                    finally {
                        this.lobFiles.clear();
                    }
                }
            }
        }
    }

    private int getIncLOBKey() {
        int newKey;
        if ((newKey = ++this.rootConnection.lobHMKey) == 32768 || newKey == 32770 || newKey == 32772 || newKey == 32774 || newKey == 32776) {
            newKey = ++this.rootConnection.lobHMKey;
        }
        if (newKey == Integer.MIN_VALUE || newKey == 0) {
            this.rootConnection.lobHMKey = 1;
            newKey = 1;
        }
        return newKey;
    }

    void addLOBReference(Object lobReference) {
        if (this.rootConnection.lobReferences == null) {
            this.rootConnection.lobReferences = new WeakHashMap();
        }
        this.rootConnection.lobReferences.put(lobReference, null);
    }

    public HashMap getlobHMObj() {
        if (this.rootConnection.lobHashMap == null) {
            this.rootConnection.lobHashMap = new HashMap();
        }
        return this.rootConnection.lobHashMap;
    }

    public void cancelRunningStatement() {
        this.getLanguageConnection().getStatementContext().cancel();
    }

    public String getCurrentSchemaName() {
        return this.getLanguageConnection().getCurrentSchemaName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLobFile(LOBFile lobFile) {
        EmbedConnection embedConnection = this;
        synchronized (embedConnection) {
            if (this.lobFiles == null) {
                this.lobFiles = new HashSet();
            }
            this.lobFiles.add(lobFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLobFile(LOBFile lobFile) {
        EmbedConnection embedConnection = this;
        synchronized (embedConnection) {
            this.lobFiles.remove(lobFile);
        }
    }
}

