/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.TriggerEvent;

abstract class GenericTriggerExecutor {
    final InternalTriggerExecutionContext tec;
    final TriggerDescriptor triggerd;
    final Activation activation;
    final LanguageConnectionContext lcc;
    private ExecPreparedStatement ps;
    private Activation spsActivation;

    GenericTriggerExecutor(InternalTriggerExecutionContext tec, TriggerDescriptor triggerd, Activation activation, LanguageConnectionContext lcc) {
        this.tec = tec;
        this.triggerd = triggerd;
        this.activation = activation;
        this.lcc = lcc;
    }

    abstract void fireTrigger(TriggerEvent var1, CursorResultSet var2, CursorResultSet var3) throws StandardException;

    protected SPSDescriptor getWhenClause() throws StandardException {
        return this.triggerd.getWhenClauseSPS();
    }

    protected SPSDescriptor getAction() throws StandardException {
        return this.triggerd.getActionSPS(this.lcc);
    }

    protected void executeSPS(SPSDescriptor sps) throws StandardException {
        boolean recompile = false;
        while (true) {
            if (this.ps == null || recompile) {
                this.ps = sps.getPreparedStatement();
                this.ps = this.ps.getClone();
                this.ps.setValid();
                this.spsActivation = this.ps.getActivation(this.lcc, false);
                this.ps.setSource(sps.getText());
                this.ps.setSPSAction();
            }
            StatementContext active_sc = this.lcc.getStatementContext();
            try {
                ResultSet rs = this.ps.executeSubStatement(this.activation, this.spsActivation, false, 0L);
                if (rs.returnsRows()) {
                    while (rs.getNextRow() != null) {
                    }
                }
                rs.close();
            }
            catch (StandardException e) {
                StatementContext sc = this.lcc.getStatementContext();
                if (active_sc != sc) {
                    sc.cleanupOnError(e);
                }
                if (e.getMessageId().equals("XCL32.S")) {
                    recompile = true;
                    sps.revalidate(this.lcc);
                    continue;
                }
                this.spsActivation.close();
                throw e;
            }
            break;
        }
    }

    protected void clearSPS() throws StandardException {
        if (this.spsActivation != null) {
            this.spsActivation.close();
        }
        this.ps = null;
        this.spsActivation = null;
    }
}

