/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.sql.execute.rts.RealDeleteResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.ResultSetStatistics;

public class RealDeleteCascadeResultSetStatistics
extends RealDeleteResultSetStatistics {
    public ResultSetStatistics[] dependentTrackingArray;

    public RealDeleteCascadeResultSetStatistics(int rowCount, boolean deferred, int indexesUpdated, boolean tableLock, long executeTime, ResultSetStatistics sourceResultSetStatistics, ResultSetStatistics[] dependentTrackingArray) {
        super(rowCount, deferred, indexesUpdated, tableLock, executeTime, sourceResultSetStatistics);
        this.dependentTrackingArray = dependentTrackingArray;
    }

    public String getStatementExecutionPlanText(int depth) {
        String dependentInfo = "";
        this.initFormatInfo(depth);
        if (this.dependentTrackingArray != null) {
            boolean foundAttached = false;
            for (int index = 0; index < this.dependentTrackingArray.length; ++index) {
                if (this.dependentTrackingArray[index] == null) continue;
                if (!foundAttached) {
                    dependentInfo = this.indent + "\n" + MessageService.getTextMessage("43Y53.U") + ":\n";
                    foundAttached = true;
                }
                dependentInfo = dependentInfo + this.dependentTrackingArray[index].getStatementExecutionPlanText(this.sourceDepth);
            }
        }
        return this.indent + MessageService.getTextMessage("43Y52.U") + " " + MessageService.getTextMessage(this.tableLock ? "43X14.U" : "43X15.U") + ":\n" + this.indent + MessageService.getTextMessage("43X16.U") + ": " + this.deferred + "\n" + this.indent + MessageService.getTextMessage("43X17.U") + " = " + this.rowCount + "\n" + this.indent + MessageService.getTextMessage("43X18.U") + " = " + this.indexesUpdated + "\n" + this.dumpTimeStats(this.indent) + (this.sourceResultSetStatistics == null ? "" : this.sourceResultSetStatistics.getStatementExecutionPlanText(1)) + dependentInfo;
    }

    public String getScanStatisticsText(String tableName, int depth) {
        String dependentInfo = "";
        if (this.dependentTrackingArray != null) {
            for (int index = 0; index < this.dependentTrackingArray.length; ++index) {
                if (this.dependentTrackingArray[index] == null) continue;
                dependentInfo = dependentInfo + "\n" + MessageService.getTextMessage("43Y54.U") + " " + index + "\n" + this.dependentTrackingArray[index].getScanStatisticsText(tableName, depth) + MessageService.getTextMessage("43Y55.U") + " " + index + "\n\n";
            }
        }
        return dependentInfo + (this.sourceResultSetStatistics == null ? "" : this.sourceResultSetStatistics.getScanStatisticsText(tableName, depth));
    }

    public String getNodeName() {
        return MessageService.getTextMessage("43Y51.U");
    }
}

