/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.sql.execute.rts.RealJoinResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.ResultSetStatistics;

public class RealNestedLoopJoinStatistics
extends RealJoinResultSetStatistics {
    public boolean oneRowRightSide;
    public ResultSetStatistics leftResultSetStatistics;
    public ResultSetStatistics rightResultSetStatistics;
    protected String nodeName;
    protected String resultSetName;

    public RealNestedLoopJoinStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, int rowsSeenLeft, int rowsSeenRight, int rowsReturned, long restrictionTime, boolean oneRowRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides, ResultSetStatistics leftResultSetStatistics, ResultSetStatistics rightResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, rowsSeenLeft, rowsSeenRight, rowsReturned, restrictionTime, optimizerEstimatedRowCount, optimizerEstimatedCost, userSuppliedOptimizerOverrides);
        this.oneRowRightSide = oneRowRightSide;
        this.leftResultSetStatistics = leftResultSetStatistics;
        this.rightResultSetStatistics = rightResultSetStatistics;
        this.setNames();
    }

    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        String header = "";
        if (this.userSuppliedOptimizerOverrides != null) {
            header = this.indent + MessageService.getTextMessage("43Y57.U", this.userSuppliedOptimizerOverrides);
            header = header + "\n";
        }
        return header + this.indent + this.resultSetName + ":\n" + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X79.U") + " = " + this.rowsSeenLeft + "\n" + this.indent + MessageService.getTextMessage("43X80.U") + " = " + this.rowsSeenRight + "\n" + this.indent + MessageService.getTextMessage("43X32.U") + " = " + this.rowsFiltered + "\n" + this.indent + MessageService.getTextMessage("43X81.U") + " = " + this.rowsReturned + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X82.U") + ":\n" + this.leftResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n" + this.indent + MessageService.getTextMessage("43X83.U") + ":\n" + this.rightResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    public String getScanStatisticsText(String tableName, int depth) {
        return this.leftResultSetStatistics.getScanStatisticsText(tableName, depth) + this.rightResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public Vector getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.leftResultSetStatistics);
        children.addElement(this.rightResultSetStatistics);
        return children;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    protected void setNames() {
        if (this.nodeName == null) {
            if (this.oneRowRightSide) {
                this.nodeName = MessageService.getTextMessage("43X84.U");
                this.resultSetName = MessageService.getTextMessage("43X85.U");
            } else {
                this.nodeName = MessageService.getTextMessage("43X86.U");
                this.resultSetName = MessageService.getTextMessage("43X87.U");
            }
        }
    }
}

