/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.response.artifacts;

import java.io.StringWriter;
import java.util.List;
import org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.response.artifacts.GraphElementCollection;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IRelationshipConvertible;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;

public class Edges
extends GraphElementCollection
implements IEdges {
    public Edges(String templateId) {
        super(templateId);
    }

    public Edges(IRelationshipTemplate relationshipTemplate) {
        super(relationshipTemplate);
    }

    public Edges(IRelationshipTemplate relationshipTemplate, IRelationshipConvertible relationshipConvertible) {
        super(relationshipTemplate);
        this.addRelationship(relationshipConvertible);
    }

    public Edges(IRelationshipTemplate relationshipTemplate, List relationships) {
        super(relationshipTemplate, relationships);
    }

    public void addRelationship(IRelationshipConvertible relationship) {
        this.getCollection().add(relationship.toRelationship(this));
    }

    public void addRelationship(IRelationship relationship) {
        this.getCollection().add(relationship);
    }

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write("<cmdbf:edges templateId=\"" + this.getId() + "\"" + ">" + ICMDBfServicesConstants.nl);
        CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), (List)this.getCollection());
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)"cmdbf:edges")) + ICMDBfServicesConstants.nl);
    }

    public int getType() {
        return 2;
    }

    public IRelationshipTemplate getRelationshipTemplate() {
        return (IRelationshipTemplate)this.getTemplate();
    }

    public IRelationship[] getRelationships() {
        IGraphElement[] elements = super.getElements();
        if (elements == null) {
            return new IRelationship[0];
        }
        IRelationship[] relationships = new IRelationship[elements.length];
        int i = 0;
        while (i < elements.length) {
            relationships[i] = (IRelationship)elements[i];
            ++i;
        }
        return relationships;
    }
}

