/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ConstraintNode;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DataBuilderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementDeclarationCollection
extends ArrayList<ConstraintNode> {
    private static final long serialVersionUID = 3065372992318203085L;
    private Map<String, Map<String, ConstraintNode>> uriNameIndex = new Hashtable<String, Map<String, ConstraintNode>>();

    public ConstraintNode get(QName qName) {
        ConstraintNode targetSchemaNode;
        Map<?, ?> nestedMap = SMLValidatorUtil.retrieveNestedMap(this.uriNameIndex, qName.getNamespaceURI(), false);
        ConstraintNode constraintNode = targetSchemaNode = nestedMap == null ? null : (ConstraintNode)nestedMap.get(qName.getLocalPart());
        if (targetSchemaNode == null) {
            return null;
        }
        if (targetSchemaNode != null && targetSchemaNode.getName() == null && targetSchemaNode.getRef() != null) {
            return DataBuilderUtil.retrieveElement(targetSchemaNode.getRef());
        }
        return targetSchemaNode;
    }

    @Override
    public boolean add(ConstraintNode localElementDeclaration) {
        String localName;
        QName ref = localElementDeclaration.getRef();
        boolean isReference = ref != null;
        String uri = isReference ? ref.getNamespaceURI() : localElementDeclaration.getUri();
        String string = localName = isReference ? ref.getLocalPart() : localElementDeclaration.getName();
        if (uri != null && localName != null) {
            Map<?, ?> nestedMap = SMLValidatorUtil.retrieveNestedMap(this.uriNameIndex, uri, true);
            nestedMap.put(localName, localElementDeclaration);
        }
        return super.add(localElementDeclaration);
    }
}

