/*******************************************************************************
 * Copyright (c) 2007, 2009 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import org.eclipse.cosmos.rm.internal.validation.SMLActivator;
import org.eclipse.cosmos.rm.internal.validation.artifacts.DOMStructure;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementLocation;
import org.w3c.dom.Element;

/**
 * Keeps track of DOM representations of
 * instance documents
 *
 * @author Ali Mehregani
 * @author John Arwe
 */
public class DocumentDOMBuilder extends AbstractDataBuilder<DOMStructure>
{
	/**
	 * The ID of this builder
	 */
	public static final String ID = SMLActivator.PLUGIN_ID + ".DocumentDOMBuilder";

	/**
	 * The data structure
	 */
	private DOMStructure domStructure;


	/**
	 * Constructor
	 */
	public DocumentDOMBuilder()
	{
		reset();
	}


	/**
	 * @see org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder#reset()
	 */
	public void reset()
	{
		domStructure = new DOMStructure();
		super.reset();
	}


	/**
	 * @see org.eclipse.cosmos.rm.internal.validation.databuilders.IDataBuilder#getDataStructure()
	 */
	public DOMStructure getDataStructure()
	{
		return domStructure;
	}

	public ElementLocation getLocation(Element currentElement) {
		return domStructure.getLocation(currentElement);
	}
}