/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.cmdbf.services.query.transform.input.artifacts;

import java.io.StringWriter;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.IQueryTransformerConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IDepthLimit;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRelationshipEndpoint;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate;

/**
 * Templates indicating a relationship between items.
 * 
 * @author David Whiteman
 */
public class RelationshipTemplate extends Template implements IRelationshipTemplate
{
	private IRelationshipEndpoint sourceElement; 	// required
	private IRelationshipEndpoint targetElement; 	// required
	private IDepthLimit depthLimit;			// optional
	
	public RelationshipTemplate(String id)
	{
		super(id);		
	}

	
	public IRelationshipEndpoint getSourceElement() 
	{
		return sourceElement;
	}

	
	public void setSourceElement(IRelationshipEndpoint sourceElement) 
	{
		this.sourceElement = sourceElement;
	}

	
	public IRelationshipEndpoint getTargetElement() 
	{
		return targetElement;
	}

	
	public void setTargetElement(IRelationshipEndpoint targetElement) 
	{
		this.targetElement = targetElement;
	}
	
	
	public IDepthLimit getDepthLimit()
	{		
		return depthLimit;
	}

	
	public void setDepthLimit(IDepthLimit depthLimit)
	{
		this.depthLimit = depthLimit;
	}
	
	
	protected String getElementName() {
		return IQueryTransformerConstants.RELATIONSHIP_TEMPLATE_ELEMENT;
	}

	
	protected void outputAdditionalSubelements(StringWriter writer, int indent) 
	{
		getSourceElement().toXML(writer, indent);
		getTargetElement().toXML(writer, indent);
		if (depthLimit != null) {
			getDepthLimit().toXML(writer, indent);
		}
	}

	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result
				+ ((depthLimit == null) ? 0 : depthLimit.hashCode());
		result = prime * result
				+ ((sourceElement == null) ? 0 : sourceElement.hashCode());
		result = prime * result
				+ ((targetElement == null) ? 0 : targetElement.hashCode());
		return result;
	}

	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RelationshipTemplate other = (RelationshipTemplate) obj;
		if (depthLimit == null) {
			if (other.depthLimit != null)
				return false;
		} else if (!depthLimit.equals(other.depthLimit))
			return false;
		if (sourceElement == null) {
			if (other.sourceElement != null)
				return false;
		} else if (!sourceElement.equals(other.sourceElement))
			return false;
		if (targetElement == null) {
			if (other.targetElement != null)
				return false;
		} else if (!targetElement.equals(other.targetElement))
			return false;
		return true;
	}
}
