/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.smlif.common;

import org.eclipse.cosmos.rm.internal.smlif.editor.AbstractFormPage;
import org.eclipse.jface.wizard.WizardPage;

/**
 * Wrapper for the various types of pages
 * used in the SML tooling UIs
 * 
 * @author David Whiteman
 */
public class SMLPage {
	protected WizardPage wizardPage;
	protected AbstractFormPage formPage;

	public SMLPage(AbstractFormPage formPage) {
		super();
		this.formPage = formPage;
	}
	public SMLPage(WizardPage wizardPage) {
		super();
		this.wizardPage = wizardPage;
	}
	
	public void setErrorMessage(String message) {
		if (wizardPage != null) {
			wizardPage.setErrorMessage(message);
		} else {
			formPage.setErrorMessage(message);
		}
	}
}
