/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service.impl;

import java.util.Map;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.IQueryHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;

/**
 * An abstract implementation of {@link IQueryHandler}.  Clients can
 * choose to extend this class or provide a direct implementation.
 * 
 * 
 * @author Ali Mehregani
 */
public abstract class AbstractQueryHandler implements IQueryHandler
{
	/**
	 * The init data
	 */
	private Map<String, Object> init;
	
	/**
	 * The runtime options
	 */
	private Map<String, Object> runtimeOptions;
	
	/**
	 * A flag used to indicate if this handler is initialized
	 */
	private boolean initialized;

	
	/**
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.IQueryHandler#initialize(org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.IDataProvider)
	 */
	public void initialize(Map<String, Object> init) throws CMDBfServiceException
	{		
		this.init = init;
		this.initialized = true;
	}

	
	/**
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.IQueryHandler#isInitialized()
	 */
	public boolean isInitialized()
	{				
		return initialized;
	}
	
	
	/**
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.IQueryHandler#getRuntimeOptions()
	 */
	public Map<String, Object> getRuntimeOptions()
	{		
		return runtimeOptions;
	}
	
	
	/**
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.IQueryHandler#setRuntimeOptions(java.util.Map)
	 */
	public void setRuntimeOptions(Map<String, Object> options)
	{
		this.runtimeOptions = options;
	}
	
	/**
	 * Returns the value of the item stored in the 
	 * init data with the key passed in 
	 * 
	 * @return The value of key
	 */
	protected Object getValue(Object key)
	{
		return init.get(key);
	}
	
}
