/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.cmdbf.services.metadata.transform.input.artifacts;

import java.io.StringWriter;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.ServiceMetadataConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IPropertyValueOperators;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts.IRecordConstraintSupport;


public class RecordConstraintSupport implements IRecordConstraintSupport 
{
	private boolean recordTypeConstraint;
	private boolean propertyValueConstraint;
	private IPropertyValueOperators propertyValueOperators = null;

	
	/**
	 * set the recordTypeConstraint 
	 * 
	 * @param recordTypeConstraint
	 */
	public void setRecordTypeConstraint(boolean recordTypeConstraint){
		this.recordTypeConstraint = recordTypeConstraint;
	}
		
	/**
	 * Retrieve the recordTypeConstraint
	 * 
	 * @return recordTypeConstraint
	 */
	public boolean isRecordTypeConstraint(){
		return recordTypeConstraint;
	}

	
	/**
	 * set the propertyValueConstraint
	 * 
	 * @param propertyValueConstraint
	 */
	public void setPropertyValueConstraint(boolean propertyValueConstraint){
		this.propertyValueConstraint = propertyValueConstraint;
	}
		
	/**
	 * Retrieve the propertyValueConstraint
	 * 
	 * @return Boolean propertyValueConstraint
	 */
	public boolean isPropertyValueConstraint(){
		return propertyValueConstraint;
	}

	
	
	/**
	 * set the propertyValueOperators
	 * 
	 * @param propertyValueOperators
	 */
	public void setPropertyValueOperators(IPropertyValueOperators propertyValueOperators){
		this.propertyValueOperators = propertyValueOperators;
	}
		
	/**
	 * Retrieve the propertyValueOperators
	 * 
	 * @return IPropertyValueOperators propertyValueOperators
	 */
	public IPropertyValueOperators getPropertyValueOperators(){
		return propertyValueOperators;
	}

	
	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.tagFor(false, null, ServiceMetadataConstants.RECORDCONSTRAINTSUPPORT_ELEMENT, false));
				
		writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
		CMDBfServicesUtil.writeAttribute(writer, ServiceMetadataConstants.RECORDTYPECONSTRAINT_ATTRIBUTE, String.valueOf(recordTypeConstraint));
	
		writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
		CMDBfServicesUtil.writeAttribute(writer, ServiceMetadataConstants.PROPERTYVALUECONSTRAINT_ATTRIBUTE, String.valueOf(propertyValueConstraint));

		
		if ( propertyValueOperators != null ){
			writer.write(ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);

			propertyValueOperators.toXML(writer, indent+1);
			
			CMDBfServicesUtil.addIndent(writer, indent);
			writer.write(CMDBfServicesUtil.endTagFor(ServiceMetadataConstants.RECORDCONSTRAINTSUPPORT_ELEMENT)+ICMDBfServicesConstants.nl);
		} else {			
			writer.write(ICMDBfServicesConstants.FORWARD_SLASH+ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
		}
	}


	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RecordConstraintSupport other = (RecordConstraintSupport) obj;
		if (propertyValueConstraint != other.propertyValueConstraint ||
			recordTypeConstraint != other.recordTypeConstraint)
		{
			return false;
		}
		
		if (propertyValueOperators == null) {
			if (other.propertyValueOperators != null)
				return false;
		} else if (!propertyValueOperators.equals(other.propertyValueOperators))
			return false;

		return true;
	}
	
}
