/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.profile.cim.handler;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.sdd.cr.IResourceHandler;
import org.eclipse.cosmos.me.sdd.profile.cim.Version;
import org.eclipse.cosmos.me.sdd.schema.CapacityConstraintType;
import org.eclipse.cosmos.me.sdd.schema.CapacityValueType;
import org.eclipse.cosmos.me.sdd.schema.ConditionalPropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ConsumptionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.PropertyConstraintType;
import org.eclipse.cosmos.me.sdd.schema.PropertyValueListType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintType;
import org.eclipse.cosmos.me.sdd.schema.VersionConstraintValueType;
import org.eclipse.cosmos.me.sdd.schema.VersionRangeType;
import org.eclipse.cosmos.me.sdd.schema.VersionValueType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;

public class OSHandler
implements IResourceHandler {
    static final QName OS = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_OperatingSystem");
    static final QName OS_TYPE = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_OperatingSystem.OSType");
    static final QName OS_MEMSIZE = new QName("http://docs.oasis-open.org/sdd/ns/cim-profile", "CIM_OperatingSystem.TotalVisibleMemorySize");
    static final String Windows = "Windows";

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, CapacityConstraintType constraint) {
        String minCapacity;
        String maxCapacity;
        boolean result = true;
        Object value = this.getPropertyValue(ctxt, rsrc, constraint.getPropertyName());
        CapacityValueType capacityValue = constraint.getValue();
        String unit = capacityValue.getUnit();
        long multiplyer = 1L;
        if (unit.equals("megabytes")) {
            multiplyer = 1024L;
        }
        if ((maxCapacity = capacityValue.getMaximum()) != null) {
            boolean bl = result = result && ((Long)value).compareTo(Long.valueOf(maxCapacity) * multiplyer) <= 0;
        }
        if ((minCapacity = capacityValue.getMinimum()) != null) {
            result = result && ((Long)value).compareTo(Long.valueOf(minCapacity) * multiplyer) >= 0;
        }
        return true;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, ConsumptionConstraintType constraint) {
        return false;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, PropertyConstraintType constraint) {
        return this.evaluatePropertyConstraint(ctxt, rsrc, constraint);
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, ConditionalPropertyConstraintType constraint) {
        return this.evaluatePropertyConstraint(ctxt, rsrc, constraint);
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, RequirementResourceConstraintType constraint) {
        boolean result = true;
        for (Object o : constraint.getResourceConstraintGroup()) {
            if (!(o instanceof JAXBElement)) continue;
            Object value = ((JAXBElement)o).getValue();
            if (value instanceof PropertyConstraintType) {
                result = result && this.evaluate(ctxt, rsrc, (PropertyConstraintType)value);
                continue;
            }
            if (value instanceof ConsumptionConstraintType) {
                result = result && this.evaluate(ctxt, rsrc, (ConsumptionConstraintType)value);
                continue;
            }
            if (value instanceof VersionConstraintType) {
                boolean bl = result = result && this.evaluate(ctxt, rsrc, (VersionConstraintType)value);
            }
            if (!(value instanceof CapacityConstraintType)) continue;
            boolean bl = result = result && this.evaluate(ctxt, rsrc, (CapacityConstraintType)value);
        }
        return result;
    }

    public boolean evaluate(SDDContext ctxt, ResourceType rsrc, VersionConstraintType constraint) {
        if (OS.equals(rsrc.getType())) {
            Version version = new Version((String)this.getVersionValue(ctxt, rsrc));
            VersionConstraintValueType supported = constraint.getSupported();
            if (supported != null) {
                Version v;
                for (VersionValueType value : supported.getValue()) {
                    v = new Version(value.getVersion());
                    if (version.compareTo(v) != 0) continue;
                    return true;
                }
                for (VersionRangeType range : supported.getRange()) {
                    if (range.getMinVersion() != null && version.compareTo(v = new Version(range.getMinVersion())) < 0 || range.getMaxVersion() != null && version.compareTo(v = new Version(range.getMaxVersion().getValue())) > 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Object getPropertyValue(SDDContext ctxt, ResourceType rsrc, QName qname) {
        if (OS.equals(rsrc.getType())) {
            if (OS_TYPE.equals(qname)) {
                return System.getProperty("os.name");
            }
            if (OS_MEMSIZE.equals(qname)) {
                return Runtime.getRuntime().freeMemory();
            }
        }
        return null;
    }

    public Object getVersionValue(SDDContext ctxt, ResourceType rsrc) {
        if (OS.equals(rsrc.getType())) {
            return System.getProperty("os.version");
        }
        return null;
    }

    private boolean evaluatePropertyConstraint(SDDContext ctxt, ResourceType rsrc, Object obj) {
        ConditionalPropertyConstraintType constraint;
        PropertyValueListType pvlt = null;
        String constraintValue = null;
        Object value = null;
        if (obj instanceof ConditionalPropertyConstraintType) {
            constraint = (ConditionalPropertyConstraintType)obj;
            value = this.getPropertyValue(ctxt, rsrc, constraint.getPropertyName());
            pvlt = constraint.getListOfValues();
            constraintValue = constraint.getValue();
        } else if (obj instanceof PropertyConstraintType) {
            constraint = (PropertyConstraintType)obj;
            value = this.getPropertyValue(ctxt, rsrc, constraint.getPropertyName());
            pvlt = constraint.getListOfValues();
            constraintValue = constraint.getValue();
        }
        if (pvlt != null) {
            for (JAXBElement e : pvlt.getValue()) {
                if (!((String)e.getValue()).equals(value)) continue;
                return true;
            }
        } else if (constraintValue.equals(value)) {
            return true;
        }
        return false;
    }
}

