package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Iterator;
import java.util.List;

import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.schema.ResultingChangeType;

public class ResultingChangeCompare
{

	protected static boolean equals(List<ResultingChangeType> r, List<ResultingChangeType> r2)
	{
		if (r.size()!=r2.size())
			return false;
		
		Iterator <ResultingChangeType> iter = r.iterator();
		
		while (iter.hasNext())
		{
			ResultingChangeType o = iter.next();
			
			Iterator <ResultingChangeType> iter2 = r2.iterator();
			boolean notfound = true;
			ResultingChangeType o2 = null;
			while (iter2.hasNext()&&notfound)
			{
				o2 = iter2.next();
				if (equals(o,o2))
					notfound = false;
			}
			if (notfound)
				return false;
			else
				r2.remove(o2);
		}
		
		return true;
	}
	
	protected static boolean equals(ResultingChangeType o, ResultingChangeType o2)
	{
		if(!ResourceCompare.equals((ResourceType)o.getResourceRef(), (ResourceType)o2.getResourceRef()))
			return false;
		if(!ConditionCompare.equals(o.getCondition(), o2.getCondition()))
			return false;
		return true;
	}

}
