/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.Messages;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.interfaces.IDMToolkitConstants;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.util.Utilities;

/**
 * Describes the properties of the registration service implementation.
 * 
 * @author David Whiteman
 */
public class RegistrationServiceProjectConfig extends AbstractProjectConfig {
	
	@Override
	protected String defaultDataManagerName() {
		return Messages.projectConfigMDRClassNameDefault;
	}

	@Override
	public String getProjectTypeName() {
		return Messages.projectConfigMDRType;
	}
	
	@Override
	public boolean isRegistrationServiceConfig() {
		return true;
	}

	public String getServiceSpecificImports() {
		StringWriter writer = new StringWriter();
		writer.write("import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.INotificationHandlerFactory;\n");
		return writer.toString();
	}

	@Override
	public String getGeneratedClassName() {
		return getName() + IDMToolkitConstants.SUFFIX_SERVICE_REGISTRATION;
	}
	
	@Override
	public String getClassSource() throws CoreException {
		String[] substitutionMap = {
				"%PACKAGE_NAME%", getPackageName(),
				"%EXTRA_IMPORTS%", getServiceSpecificImports(),
				"%MDR_CLASS%", getGeneratedClassName(),
				"%ABSTRACT_PARENT_CLASS_FULL%", getParentClassNameFull(),
				"%ABSTRACT_PARENT_CLASS%", getParentClassName(),
				"%OPERATION_INITS%", getOperationInits(),
				"%SERVICE_SPECIFIC_CODE%", getServiceSpecificSource()
		};
		String resourceLocation = IDMToolkitConstants.RESOURCES_MDR_TEMPLATE;
		return Utilities.populateResourceTemplate(substitutionMap, resourceLocation);
	}

	protected String getParentClassNameFull() {
		return IDMToolkitConstants.PARENT_CLASS_REGISTRATION_SERVICE; //$NON-NLS-1$ //$NON-NLS-2$
	}

	public String getServiceSpecificSource() throws CoreException {
		return Utilities.populateResourceTemplate(new String[] {}, "resources/regServiceMethodOverride.txt");
	}

	protected String getOperationInits() {
		StringWriter writer = new StringWriter();
		writer.write("\n\t\tgetRegistrationOperation().initialize(init);");
		writer.write("\n\t\tgetDeregistrationOperation().initialize(init);");
		return writer.toString();
	}
	
	public List<String> getWsdlFilesToCopy() {
		List<String> dmList = new ArrayList<String>();
		dmList.add(IDMToolkitConstants.REGISTRATION_SERVICE_WSDL);
		dmList.add(IDMToolkitConstants.CMDBF_REGISTRATION_WSDL);
		return dmList;
	}

}
