/*******************************************************************************
 * Copyright (c) 2008, 2009 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.internal.dmtoolkit.common.ui;

import org.eclipse.cosmos.me.internal.dmtoolkit.common.Messages;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.interfaces.IProjectConfig;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.util.Utilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/**
 * Wizard page for configuring basic properties of a data manager project.
 * 
 * 
 * @author David Whiteman
 */
public class DataManagerConfigPage extends WizardPage {

	private IProjectConfig model = null;
	private Text packageNameTextField;
	private Text nameTextField;
	private String nameTextLabel;

	static String CONTEXT_ID_MDR_CONFIG_PAGE = "org.eclipse.cosmos.me.dmtoolkit.common.dataManagerConfigPage";
	
	protected DataManagerConfigPage(String pageName) {
		super(pageName);
	}

	public void createControl(Composite parent) {
		final Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, CONTEXT_ID_MDR_CONFIG_PAGE);

		String packageNameFieldInitialContents = getModel().getPackageName();
		this.packageNameTextField = Utilities.createLabelTextPair(composite, Messages.wizardPagePackageNameField,
				packageNameFieldInitialContents, false);

		String dataManagerNameInitialContents = getModel().getName();
		this.nameTextField = Utilities.createLabelTextPair(composite, getNameTextLabel(), dataManagerNameInitialContents, false);

		this.nameTextField.addVerifyListener(new VerifyListener() {
			// we want to make sure the name can be used as part of a generated class name
			public void verifyText(VerifyEvent e) {
				// Using Identifier naming rules from JLS
				if (!Character.isJavaIdentifierPart(e.character)) {
					e.doit = false;
					return;
				}
				Text widget = (Text) e.widget;
				if (widget.getCharCount() == 0) {
					// If this is the first char, the restriction is greater
					if (!Character.isJavaIdentifierStart(e.character)) {
						e.doit = false;
						return;
					}
					// Even though Java identifiers can start with a lowercase char, we will enforce the convention
					e.text = e.text.toUpperCase();
				}
			}
		});

		setControl(composite);
		Dialog.applyDialogFont(composite);
	}

	public void setModel(Object model) {
		this.model = (IProjectConfig) model;
	}

	public IProjectConfig getModel() {
		return model;
	}

	public void transferStateToModel() {
		getModel().setName(this.nameTextField.getText());
		getModel().setPackageName(this.packageNameTextField.getText());
	}

	public String getNameTextLabel() {
		if (nameTextLabel == null) {
			nameTextLabel = Messages.wizardPageDataManagerNameField;
		}
		return nameTextLabel;
	}

	public void setNameTextLabel(String nameTextLabel) {
		this.nameTextLabel = nameTextLabel;
	}
}
