/*******************************************************************************
 * Copyright (c) 2007, 2008 CA, Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.examples.dr.drs.service.outputter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.eclipse.cosmos.common.provisional.exceptions.CosmosException;
import org.eclipse.cosmos.dc.internal.logging.datamgr.client.CBEClient;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;
import org.apache.log4j.Logger;
public class CBEDataSourceOutputter extends AbstractOutputter {
	private static Logger logger = Logger.getLogger(CBEDataSourceOutputter.class);

	public void render(PrintWriter output, IParameters input) throws Exception {

		String title = input.getParameter("title"); //$NON-NLS-1$
		String prop = input.getParameter("prop"); //$NON-NLS-1$
		String eprparm = input.getParameter("epr"); //$NON-NLS-1$

		Collection<CommonBaseEvent> cbe_coll = null;
		CBEClient dmc = new CBEClient (eprparm);

		if (dmc == null){
			throw new CosmosException(Messages.getString("CBEDataSourceOutputter.3")); //$NON-NLS-1$
		}

		if ( prop != null && prop.equalsIgnoreCase("true")){ //$NON-NLS-1$
 			try {
 				cbe_coll = dmc.getAllCBE(title);
 			} catch (CosmosException ex) {
 				throw new CosmosException(Messages.getString("CBEDataSourceOutputter.5") + title, ex); //$NON-NLS-1$
			}
			
			if (cbe_coll != null) {
				Iterator<CommonBaseEvent> I_cbe = cbe_coll.iterator();
				output.print("["); //$NON-NLS-1$
				while (I_cbe.hasNext()){
					CommonBaseEvent cbe = I_cbe.next(); 

					output.print("	[ \"Name\", '" + title + "'],"); //$NON-NLS-1$ //$NON-NLS-2$
					output.print("	[ \"Creation Time\", '" + cbe.getCreationTime().replace('T', ' ') + "'],"); //$NON-NLS-1$ //$NON-NLS-2$
					output.print("	[ \"Extension Name\", '" + cbe.getExtensionName() + "'],"); //$NON-NLS-1$ //$NON-NLS-2$
					//output.print("	[ \"Msg\", '" + cbe.getMsg() + "'],");
					output.print("	[ \"SubComponent\", '" + cbe.getSourceComponentId().getSubComponent() + "'],"); //$NON-NLS-1$ //$NON-NLS-2$
					output.print("	[ \"Location\", '" + cbe.getSourceComponentId().getLocation() + "']"); //$NON-NLS-1$ //$NON-NLS-2$
				}
				output.print("]");			 //$NON-NLS-1$
			} else {
				logger.warn(Messages.getString("CBEDataSourceOutputter.18") + title); //$NON-NLS-1$
			}
		} else {
			// get the data sources from the CBE Data Manager client
			Collection<String> dsn_coll = null;
			
			try {
				dsn_coll = dmc.getDatasets();
			} catch(CosmosException ex) {
 				throw new CosmosException(Messages.getString("CBEDataSourceOutputter.19"), ex); //$NON-NLS-1$
			}

			if (dsn_coll != null) {
				Iterator<String> I_dsn = null;
				String dsn = null;
				
				output.print("{ identifier: \"object\",  label: \"title\",  items:[" ); //$NON-NLS-1$
				I_dsn = dsn_coll.iterator();
				while (I_dsn.hasNext()){
					dsn = I_dsn.next();
					output.print("{nodeClass:\"datasource\", title:\""  //$NON-NLS-1$
							+ dsn 
							+ "\", logfile:\""  //$NON-NLS-1$
							+ dsn 
							+ "\", epr:\'" + eprparm  //$NON-NLS-1$
							+ "\', classification:\"CBE\""); //$NON-NLS-1$
					//TODO: add more properties on the datasource
					output.print(", store:["); //$NON-NLS-1$
					output.print("['epr', '"+eprparm+"']"); //$NON-NLS-1$ //$NON-NLS-2$
					output.print(",['logfile', '"+dsn+"']"); //$NON-NLS-1$ //$NON-NLS-2$
					output.print("]}"); //$NON-NLS-1$
			
					if(I_dsn.hasNext()) output.print(","); //$NON-NLS-1$
				}
				output.print("]}"); //$NON-NLS-1$
			}	
		}
		
	}
}
