/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.provisional.dr.drs.service.handler.common;

/**
 * Persistent storage used by outputters to save state
 */
public interface IStore {
	/**
	 * Returns a value from the store with provided key name
	 * @param name - key name
	 * @return stored value
	 */
	public abstract Object getAttribute(String name);
	/**
	 * Stores a value with an associated key name
	 * @param name - key name
	 * @param value - value to store 
	 */
	public abstract void setAttribute(String name, Object value);
}
