/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementModel;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementSchemaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMLDocuments {
    private Map<String, ElementSchemaModel> definitionsIndexedByNamespace = new Hashtable<String, ElementSchemaModel>();
    private Map<String, ElementSchemaModel> definitionsIndexedByAlias = new Hashtable<String, ElementSchemaModel>();
    private Map<String, ElementModel> instancesIndexedByAlias = new Hashtable<String, ElementModel>();
    private List<ElementModel> orphanedInstances = new ArrayList<ElementModel>();

    public void addInstance(ElementModel instance) {
        if (instance == null) {
            return;
        }
        String[] aliases = instance.getAliases();
        if (aliases == null || aliases.length <= 0) {
            this.orphanedInstances.add(instance);
        } else {
            int i = 0;
            while (i < aliases.length) {
                this.instancesIndexedByAlias.put(aliases[i], instance);
                ++i;
            }
        }
    }

    public ElementModel[] getInstances() {
        ArrayList<ElementModel> instanceSet = new ArrayList<ElementModel>();
        for (String alias : this.instancesIndexedByAlias.keySet()) {
            ElementModel instance = this.instancesIndexedByAlias.get(alias);
            if (instanceSet.contains(instance)) continue;
            instanceSet.add(instance);
        }
        instanceSet.addAll(this.orphanedInstances);
        return instanceSet.toArray(new ElementModel[instanceSet.size()]);
    }

    public ElementModel getInstanceByAlias(String alias) {
        return this.instancesIndexedByAlias.get(alias);
    }

    public void addDefinition(ElementSchemaModel definition) {
        if (definition == null) {
            return;
        }
        String namespace = definition.getTargetNamespace();
        if (namespace != null) {
            this.definitionsIndexedByNamespace.put(namespace, definition);
        }
        String[] aliases = definition.getAliases();
        int i = 0;
        while (i < aliases.length) {
            this.definitionsIndexedByAlias.put(aliases[i], definition);
            ++i;
        }
    }

    public ElementSchemaModel[] getDefinitions() {
        ArrayList<ElementSchemaModel> definitionSet = new ArrayList<ElementSchemaModel>();
        this.addToList(definitionSet, this.definitionsIndexedByAlias);
        this.addToList(definitionSet, this.definitionsIndexedByNamespace);
        return definitionSet.toArray(new ElementSchemaModel[definitionSet.size()]);
    }

    private void addToList(List<ElementSchemaModel> definitionSet, Map<String, ElementSchemaModel> definitions) {
        for (String key : definitions.keySet()) {
            ElementSchemaModel definition = definitions.get(key);
            if (definitionSet.contains(definition)) continue;
            definitionSet.add(definition);
        }
    }

    public ElementSchemaModel getDefinitionByAlias(String alias) {
        return this.definitionsIndexedByAlias.get(alias);
    }

    public ElementSchemaModel getDefinitionByNamespace(String namespace) {
        return this.definitionsIndexedByNamespace.get(namespace);
    }
}

