/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.IOException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.derby.client.net.NaiveTrustManager;

public class OpenSocketAction
implements PrivilegedExceptionAction {
    private String server_;
    private int port_;
    private int clientSSLMode_;

    public OpenSocketAction(String server, int port, int clientSSLMode) {
        this.server_ = server;
        this.port_ = port;
        this.clientSSLMode_ = clientSSLMode;
    }

    public Object run() throws UnknownHostException, IOException, NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException, KeyStoreException, UnrecoverableKeyException, CertificateException {
        SocketFactory sf;
        switch (this.clientSSLMode_) {
            case 1: {
                sf = NaiveTrustManager.getSocketFactory();
                break;
            }
            case 2: {
                sf = SSLSocketFactory.getDefault();
                break;
            }
            case 0: {
                sf = SocketFactory.getDefault();
                break;
            }
            default: {
                sf = SocketFactory.getDefault();
            }
        }
        return sf.createSocket(this.server_, this.port_);
    }
}

