/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.types.DataTypeDescriptor;

public final class JSQLType
implements Formatable {
    public static final byte SQLTYPE = 0;
    public static final byte JAVA_CLASS = 1;
    public static final byte JAVA_PRIMITIVE = 2;
    public static final byte NOT_PRIMITIVE = -1;
    public static final byte BOOLEAN = 0;
    public static final byte CHAR = 1;
    public static final byte BYTE = 2;
    public static final byte SHORT = 3;
    public static final byte INT = 4;
    public static final byte LONG = 5;
    public static final byte FLOAT = 6;
    public static final byte DOUBLE = 7;
    private static final String[] wrapperClassNames = new String[]{"java.lang.Boolean", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    public static final String[] primitiveNames = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"};
    private byte category = (byte)2;
    private DataTypeDescriptor sqlType;
    private String javaClassName;
    private byte primitiveKind;

    public JSQLType() {
        this.initialize((byte)4);
    }

    public JSQLType(DataTypeDescriptor sqlType) {
        this.initialize(sqlType);
    }

    public JSQLType(String javaName) {
        byte primitiveID = JSQLType.getPrimitiveID(javaName);
        if (primitiveID != -1) {
            this.initialize(primitiveID);
        } else {
            this.initialize(javaName);
        }
    }

    public JSQLType(byte primitiveKind) {
        this.initialize(primitiveKind);
    }

    public byte getCategory() {
        return this.category;
    }

    public byte getPrimitiveKind() {
        return this.primitiveKind;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public DataTypeDescriptor getSQLType() {
        if (this.sqlType == null) {
            String className = this.category == 1 ? this.javaClassName : JSQLType.getWrapperClassName(this.primitiveKind);
            this.sqlType = DataTypeDescriptor.getSQLDataTypeDescriptor(className);
        }
        return this.sqlType;
    }

    public int getTypeFormatId() {
        return 307;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte frozenCategory = in.readByte();
        switch (frozenCategory) {
            case 0: {
                this.initialize((DataTypeDescriptor)in.readObject());
                break;
            }
            case 1: {
                this.initialize((String)in.readObject());
                break;
            }
            case 2: {
                this.initialize(in.readByte());
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.category);
        switch (this.category) {
            case 0: {
                out.writeObject(this.sqlType);
                break;
            }
            case 1: {
                out.writeObject(this.javaClassName);
                break;
            }
            case 2: {
                out.writeByte(this.primitiveKind);
            }
        }
    }

    private void initialize(byte primitiveKind) {
        this.initialize((byte)2, null, null, primitiveKind);
    }

    private void initialize(DataTypeDescriptor sqlType) {
        this.initialize((byte)0, sqlType, null, (byte)-1);
    }

    private void initialize(String javaClassName) {
        this.initialize((byte)1, null, javaClassName, (byte)-1);
    }

    private void initialize(byte category, DataTypeDescriptor sqlType, String javaClassName, byte primitiveKind) {
        this.category = category;
        this.sqlType = sqlType;
        this.javaClassName = javaClassName;
        this.primitiveKind = primitiveKind;
    }

    private static String getWrapperClassName(byte primitive) {
        if (primitive == -1) {
            return "";
        }
        return wrapperClassNames[primitive];
    }

    private static byte getPrimitiveID(String name) {
        for (byte ictr = 0; ictr <= 7; ictr = (byte)(ictr + 1)) {
            if (!primitiveNames[ictr].equals(name)) continue;
            return ictr;
        }
        return -1;
    }
}

