/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import org.apache.derby.impl.io.vfmem.BlockedByteArrayInputStream;
import org.apache.derby.impl.io.vfmem.BlockedByteArrayOutputStream;
import org.apache.derby.shared.common.sanity.SanityManager;

public class BlockedByteArray {
    private static final int _4K = 4096;
    private static final int _8K = 8192;
    private static final int _16K = 16384;
    private static final int _32K = 32768;
    private static final int DEFAULT_BLOCKSIZE = 4096;
    private static final int INITIAL_BLOCK_HOLDER_SIZE = 1024;
    private static final int MIN_HOLDER_GROWTH = 1024;
    private byte[][] blocks = new byte[1024][];
    private int blockSize;
    private int allocatedBlocks;
    private long length;

    public synchronized int read(long pos) {
        if (pos < this.length) {
            int block = (int)(pos / (long)this.blockSize);
            int index = (int)(pos % (long)this.blockSize);
            return this.blocks[block][index] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(long pos, byte[] buf, int offset, int len) {
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException(len);
        }
        if (pos >= this.length) {
            return -1;
        }
        len = (int)Math.min((long)len, this.length - pos);
        int block = (int)(pos / (long)this.blockSize);
        int index = (int)(pos % (long)this.blockSize);
        int read = 0;
        while (read < len) {
            int toRead = Math.min(len - read, this.blockSize - index);
            System.arraycopy(this.blocks[block], index, buf, offset + read, toRead);
            read += toRead;
            ++block;
            index = 0;
        }
        return read;
    }

    public synchronized long length() {
        return this.length;
    }

    public synchronized void setLength(long newLength) {
        long currentCapacity;
        if (this.blockSize == 0) {
            this.checkBlockSize((int)Math.min(Integer.MAX_VALUE, newLength));
        }
        if (newLength > (currentCapacity = (long)(this.allocatedBlocks * this.blockSize))) {
            this.increaseCapacity(newLength);
        } else if (newLength < currentCapacity) {
            if (newLength <= 0L) {
                this.allocatedBlocks = 0;
                this.blocks = new byte[1024][];
            } else {
                int blocksToKeep;
                for (int i = blocksToKeep = (int)(newLength / (long)this.blockSize) + 1; i <= this.allocatedBlocks; ++i) {
                    this.blocks[i] = null;
                }
                this.allocatedBlocks = Math.min(this.allocatedBlocks, blocksToKeep);
            }
        }
        this.length = Math.max(0L, newLength);
    }

    public synchronized int writeBytes(long pos, byte[] buf, int offset, int len) {
        if (this.blockSize == 0) {
            this.checkBlockSize(len);
        }
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException(len);
        }
        if (pos + (long)len >= (long)(this.allocatedBlocks * this.blockSize)) {
            this.increaseCapacity(pos + (long)len);
        }
        int block = (int)(pos / (long)this.blockSize);
        int index = (int)(pos % (long)this.blockSize);
        int written = 0;
        while (written < len) {
            int toWrite = Math.min(len - written, this.blockSize - index);
            System.arraycopy(buf, offset, this.blocks[block], index, toWrite);
            offset += toWrite;
            if ((written += toWrite) < len) {
                ++block;
                index = 0;
                continue;
            }
            index += toWrite;
        }
        this.length = Math.max(this.length, pos + (long)len);
        return written;
    }

    public synchronized int writeByte(long pos, byte b) {
        if (this.blockSize == 0) {
            this.checkBlockSize(0);
        }
        if (pos >= (long)(this.allocatedBlocks * this.blockSize)) {
            this.increaseCapacity(pos);
        }
        int block = (int)(pos / (long)this.blockSize);
        int index = (int)(pos % (long)this.blockSize);
        this.blocks[block][index] = b;
        this.length = Math.max(this.length, pos + 1L);
        return 1;
    }

    synchronized BlockedByteArrayInputStream getInputStream() {
        return new BlockedByteArrayInputStream(this, 0L);
    }

    synchronized BlockedByteArrayOutputStream getOutputStream(long pos) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position cannot be negative: " + pos);
        }
        return new BlockedByteArrayOutputStream(this, pos);
    }

    synchronized void release() {
        this.blocks = null;
        this.allocatedBlocks = -1;
        this.length = -1;
    }

    private void checkBlockSize(int len) {
        this.blockSize = len == 4096 || len == 8192 || len == 16384 || len == 32768 ? len : 4096;
    }

    private void increaseCapacity(long lastIndex) {
        SanityManager.ASSERT(this.blockSize > 0, "Invalid/unset block size");
        if (lastIndex < (long)(this.allocatedBlocks * this.blockSize)) {
            return;
        }
        int blocksRequired = (int)(lastIndex / (long)this.blockSize) + 1;
        if (blocksRequired > this.blocks.length) {
            int growTo = Math.max(this.blocks.length + this.blocks.length / 3, blocksRequired + 1024);
            byte[][] tmpBlocks = this.blocks;
            this.blocks = new byte[growTo][];
            System.arraycopy(tmpBlocks, 0, this.blocks, 0, this.allocatedBlocks);
        }
        for (int i = this.allocatedBlocks; i < blocksRequired; ++i) {
            this.blocks[i] = new byte[this.blockSize];
        }
        this.allocatedBlocks = blocksRequired;
    }
}

