/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.stream;

import org.apache.derby.iapi.services.stream.PrintWriterGetHeader;
import org.apache.derby.iapi.util.CheapDateFormatter;

class BasicGetLogHeader
implements PrintWriterGetHeader {
    private boolean doThreadId;
    private boolean doTimeStamp;
    private String tag;

    BasicGetLogHeader(boolean doThreadId, boolean doTimeStamp, String tag) {
        this.doThreadId = doThreadId;
        this.doTimeStamp = doTimeStamp;
        this.tag = tag;
    }

    public String getHeader() {
        StringBuffer header = new StringBuffer(48);
        if (this.tag != null) {
            header.append(this.tag);
            header.append(' ');
        }
        if (this.doTimeStamp) {
            long currentTime = System.currentTimeMillis();
            header.append(CheapDateFormatter.formatDate(currentTime));
            header.append(' ');
        }
        if (this.doThreadId) {
            header.append(Thread.currentThread().toString());
            header.append(' ');
        }
        return header.toString();
    }
}

