/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

public class CoalesceFunctionNode
extends ValueNode {
    String functionName;
    ValueNodeList argumentsList;
    private int firstNonParameterNodeIdx = -1;

    public void init(Object functionName, Object argumentsList) {
        this.functionName = (String)functionName;
        this.argumentsList = (ValueNodeList)argumentsList;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        int index;
        this.argumentsList.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.argumentsList.size() < 2) {
            throw StandardException.newException("42605", this.functionName);
        }
        if (this.argumentsList.containsAllParameterNodes()) {
            throw StandardException.newException("42610");
        }
        int argumentsListSize = this.argumentsList.size();
        for (index = 0; index < argumentsListSize; ++index) {
            if (((ValueNode)this.argumentsList.elementAt(index)).requiresTypeFromContext()) continue;
            this.firstNonParameterNodeIdx = index;
            break;
        }
        for (index = 0; index < argumentsListSize; ++index) {
            if (((ValueNode)this.argumentsList.elementAt(index)).requiresTypeFromContext()) continue;
            this.argumentsList.compatible((ValueNode)this.argumentsList.elementAt(index));
        }
        this.setType(this.argumentsList.getDominantTypeServices());
        for (index = 0; index < argumentsListSize; ++index) {
            if (!((ValueNode)this.argumentsList.elementAt(index)).requiresTypeFromContext()) continue;
            ((ValueNode)this.argumentsList.elementAt(index)).setType(this.getTypeServices());
            break;
        }
        return this;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int argumentsListSize = this.argumentsList.size();
        String receiverType = "org.apache.derby.iapi.types.DataValueDescriptor";
        String argumentsListInterfaceType = "org.apache.derby.iapi.types.DataValueDescriptor[]";
        LocalField arrayField = acb.newFieldDeclaration(2, argumentsListInterfaceType);
        MethodBuilder cb = acb.getConstructor();
        cb.pushNewArray("org.apache.derby.iapi.types.DataValueDescriptor", argumentsListSize);
        cb.setField(arrayField);
        int numConstants = 0;
        MethodBuilder nonConstantMethod = null;
        MethodBuilder currentConstMethod = cb;
        for (int index = 0; index < argumentsListSize; ++index) {
            MethodBuilder setArrayMethod;
            if (this.argumentsList.elementAt(index) instanceof ConstantNode) {
                ++numConstants;
                if (currentConstMethod.statementNumHitLimit(1)) {
                    MethodBuilder genConstantMethod = acb.newGeneratedFun("void", 2);
                    currentConstMethod.pushThis();
                    currentConstMethod.callMethod((short)182, null, genConstantMethod.getName(), "void", 0);
                    if (currentConstMethod != cb) {
                        currentConstMethod.methodReturn();
                        currentConstMethod.complete();
                    }
                    currentConstMethod = genConstantMethod;
                }
                setArrayMethod = currentConstMethod;
            } else {
                if (nonConstantMethod == null) {
                    nonConstantMethod = acb.newGeneratedFun("void", 4);
                }
                setArrayMethod = nonConstantMethod;
            }
            setArrayMethod.getField(arrayField);
            ((ValueNode)this.argumentsList.elementAt(index)).generateExpression(acb, setArrayMethod);
            setArrayMethod.upCast(receiverType);
            setArrayMethod.setArrayElement(index);
        }
        if (currentConstMethod != cb) {
            currentConstMethod.methodReturn();
            currentConstMethod.complete();
        }
        if (nonConstantMethod != null) {
            nonConstantMethod.methodReturn();
            nonConstantMethod.complete();
            mb.pushThis();
            mb.callMethod((short)182, null, nonConstantMethod.getName(), "void", 0);
        }
        ((ValueNode)this.argumentsList.elementAt(this.firstNonParameterNodeIdx)).generateExpression(acb, mb);
        mb.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        mb.getField(arrayField);
        LocalField field = acb.newFieldDeclaration(2, receiverType);
        acb.generateNull(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        mb.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        mb.putField(field);
        mb.callMethod((short)185, receiverType, "coalesce", receiverType, 2);
        if (this.getTypeId().variableLength()) {
            boolean isNumber = this.getTypeId().isNumericTypeId();
            mb.dup();
            mb.push(isNumber ? this.getTypeServices().getPrecision() : this.getTypeServices().getMaximumWidth());
            mb.push(this.getTypeServices().getScale());
            mb.push(true);
            mb.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
        }
    }

    public String toString() {
        return super.toString() + this.functionName + "(" + this.argumentsList + ")\n";
    }

    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeType(o)) {
            return false;
        }
        CoalesceFunctionNode other = (CoalesceFunctionNode)o;
        if (other.argumentsList.size() != this.argumentsList.size()) {
            return false;
        }
        int size = this.argumentsList.size();
        for (int index = 0; index < size; ++index) {
            ValueNode v2;
            ValueNode v1 = (ValueNode)this.argumentsList.elementAt(index);
            if (v1.isEquivalent(v2 = (ValueNode)other.argumentsList.elementAt(index))) continue;
            return false;
        }
        return true;
    }

    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this) || v.stopTraversal()) {
            return returnNode;
        }
        int size = this.argumentsList.size();
        for (int index = 0; index < size; ++index) {
            this.argumentsList.setElementAt((QueryTreeNode)this.argumentsList.elementAt(index).accept(v), index);
        }
        return returnNode;
    }

    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        int argumentsListSize = this.argumentsList.size();
        for (int i = 0; i < argumentsListSize; ++i) {
            ((ValueNode)this.argumentsList.elementAt(i)).preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        }
        return this;
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "argumentsList: [firstNonParameterNodeIdx=" + this.firstNonParameterNodeIdx + "]");
        int argumentsListSize = this.argumentsList.size();
        for (int i = 0; i < argumentsListSize; ++i) {
            ((ValueNode)this.argumentsList.elementAt(i)).treePrint(depth + 1);
        }
    }
}

