/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

public class CreateIndexNode
extends DDLStatementNode {
    boolean unique;
    DataDictionary dd = null;
    Properties properties;
    String indexType;
    TableName indexName;
    TableName tableName;
    Vector columnNameList;
    String[] columnNames = null;
    boolean[] isAscending;
    int[] boundColumnIDs;
    TableDescriptor td;

    public void init(Object unique, Object indexType, Object indexName, Object tableName, Object columnNameList, Object properties) throws StandardException {
        this.initAndCheck(indexName);
        this.unique = (Boolean)unique;
        this.indexType = (String)indexType;
        this.indexName = (TableName)indexName;
        this.tableName = (TableName)tableName;
        this.columnNameList = (Vector)columnNameList;
        this.properties = (Properties)properties;
    }

    public String toString() {
        return super.toString() + "unique: " + this.unique + "\n" + "indexType: " + this.indexType + "\n" + "indexName: " + this.indexName + "\n" + "tableName: " + this.tableName + "\n" + "properties: " + this.properties + "\n";
    }

    public String statementToString() {
        return "CREATE INDEX";
    }

    public boolean getUniqueness() {
        return this.unique;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public TableName getIndexName() {
        return this.indexName;
    }

    public UUID getBoundTableID() {
        return this.td.getUUID();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public TableName getIndexTableName() {
        return this.tableName;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int[] getKeyColumnIDs() {
        return this.boundColumnIDs;
    }

    public boolean[] getIsAscending() {
        return this.isAscending;
    }

    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        DataDictionary dd = this.getDataDictionary();
        SchemaDescriptor sd = this.getSchemaDescriptor();
        this.td = this.getTableDescriptor(this.tableName);
        if (this.td.getTableType() == 3) {
            throw StandardException.newException("42995");
        }
        if (this.td.getTotalNumberOfIndexes() > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", (Object)String.valueOf(this.td.getTotalNumberOfIndexes()), (Object)this.tableName, (Object)String.valueOf(Short.MAX_VALUE));
        }
        this.verifyAndGetUniqueNames();
        int columnCount = this.columnNames.length;
        this.boundColumnIDs = new int[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", (Object)this.columnNames[i], (Object)this.tableName);
            }
            this.boundColumnIDs[i] = columnDescriptor.getPosition();
            if (columnDescriptor.getType().getTypeId().orderable(this.getClassFactory())) continue;
            throw StandardException.newException("X0X67.S", columnDescriptor.getType().getTypeId().getSQLTypeName());
        }
        if (columnCount > 16) {
            throw StandardException.newException("54008");
        }
        this.getCompilerContext().createDependency(this.td);
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.td.getSchemaName());
    }

    public ConstantAction makeConstantAction() throws StandardException {
        SchemaDescriptor sd = this.getSchemaDescriptor();
        int columnCount = this.columnNames.length;
        int approxLength = 0;
        boolean index_has_long_column = false;
        for (int i = 0; i < columnCount; ++i) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnNames[i]);
            DataTypeDescriptor dts = columnDescriptor.getType();
            approxLength += dts.getTypeId().getApproximateLengthInBytes(dts);
        }
        if (approxLength > 1024 && (this.properties == null || this.properties.get("derby.storage.pageSize") == null) && PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.storage.pageSize") == null) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put("derby.storage.pageSize", "32768");
        }
        return this.getGenericConstantActionFactory().getCreateIndexConstantAction(false, this.unique, false, this.indexType, sd.getSchemaName(), this.indexName.getTableName(), this.tableName.getTableName(), this.td.getUUID(), this.columnNames, this.isAscending, false, null, this.properties);
    }

    private void verifyAndGetUniqueNames() throws StandardException {
        int size = this.columnNameList.size();
        Hashtable<String, String> ht = new Hashtable<String, String>(size + 2, 0.999f);
        this.columnNames = new String[size];
        this.isAscending = new boolean[size];
        for (int index = 0; index < size; ++index) {
            this.columnNames[index] = (String)this.columnNameList.elementAt(index);
            if (this.columnNames[index].endsWith(" ")) {
                this.columnNames[index] = this.columnNames[index].substring(0, this.columnNames[index].length() - 1);
                this.isAscending[index] = false;
            } else {
                this.isAscending[index] = true;
            }
            String object = ht.put(this.columnNames[index], this.columnNames[index]);
            if (object == null || !object.equals(this.columnNames[index])) continue;
            throw StandardException.newException("42X66", this.columnNames[index]);
        }
    }
}

