/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.CursorTableReference;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class CursorNode
extends DMLStatementNode {
    public static final int UNSPECIFIED = 0;
    public static final int READ_ONLY = 1;
    public static final int UPDATE = 2;
    private String name;
    private OrderByList orderByList;
    private NumericConstantNode offset;
    private NumericConstantNode fetchFirst;
    private String statementType;
    private int updateMode;
    private boolean needTarget;
    private Vector updatableColumns;
    private FromTable updateTable;
    private ResultColumnDescriptor[] targetColumnDescriptors;
    private int indexOfSessionTableNamesInSavedObjects = -1;

    public void init(Object statementType, Object resultSet, Object name, Object orderByList, Object offset, Object fetchFirst, Object updateMode, Object updatableColumns) {
        this.init(resultSet);
        this.name = (String)name;
        this.statementType = (String)statementType;
        this.orderByList = (OrderByList)orderByList;
        this.offset = (NumericConstantNode)offset;
        this.fetchFirst = (NumericConstantNode)fetchFirst;
        this.updateMode = (Integer)updateMode;
        this.updatableColumns = (Vector)updatableColumns;
        SanityManager.ASSERT(this.updatableColumns == null || this.updatableColumns.size() == 0 || this.updateMode == 2, "Can only have explicit updatable columns if update mode is UPDATE");
    }

    public String toString() {
        return "name: " + this.name + "\n" + "updateMode: " + CursorNode.updateModeString(this.updateMode) + "\n" + super.toString();
    }

    public String statementToString() {
        return this.statementType;
    }

    private static String updateModeString(int updateMode) {
        switch (updateMode) {
            case 0: {
                return "UNSPECIFIED (0)";
            }
            case 1: {
                return "READ_ONLY (1)";
            }
            case 2: {
                return "UPDATE (2)";
            }
        }
        return "UNKNOWN VALUE (" + updateMode + ")";
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "orderByList: ");
        if (this.orderByList != null) {
            this.orderByList.treePrint(depth + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindStatement() throws StandardException {
        ArrayList sessionSchemaTableNames;
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.orderByList != null) {
            this.orderByList.pullUpOrderByColumns(this.resultSet);
        }
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        try {
            FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.resultSet.rejectParameters();
            super.bind(dataDictionary);
            this.resultSet.bindResultColumns(fromList);
            this.resultSet.bindUntypedNullsToResultColumns(null);
            this.resultSet.rejectXMLValues();
            SanityManager.ASSERT(fromList.size() == 0, "fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()");
        }
        finally {
            this.getCompilerContext().popCurrentPrivType();
        }
        if (this.orderByList != null) {
            this.orderByList.bindOrderByColumns(this.resultSet);
        }
        this.bindOffsetFetch();
        if (this.updateMode == 2) {
            int checkedUpdateMode = this.determineUpdateMode(dataDictionary);
            SanityManager.DEBUG("DumpUpdateCheck", "update mode is UPDATE (" + this.updateMode + ") checked mode is " + checkedUpdateMode);
            if (this.updateMode != checkedUpdateMode) {
                throw StandardException.newException("42Y90");
            }
        }
        if (this.updateMode == 0) {
            this.updateMode = this.getLanguageConnectionContext().getStatementContext().isForReadOnly() ? 1 : this.determineUpdateMode(dataDictionary);
        }
        if (this.updateMode == 1) {
            this.updatableColumns = null;
        }
        if (this.updateMode == 2) {
            this.bindUpdateColumns(this.updateTable);
            if (this.updateTable instanceof FromTable) {
                this.updateTable.markUpdatableByCursor(this.updatableColumns);
                this.resultSet.getResultColumns().markColumnsInSelectListUpdatableByCursor(this.updatableColumns);
            }
        }
        this.resultSet.renameGeneratedResultNames();
        if (this.getLanguageConnectionContext().checkIfAnyDeclaredGlobalTempTablesForThisConnection() && (sessionSchemaTableNames = this.getSessionSchemaTableNamesForCursor()) != null) {
            this.indexOfSessionTableNamesInSavedObjects = this.getCompilerContext().addSavedObject(sessionSchemaTableNames);
        }
    }

    private void bindOffsetFetch() throws StandardException {
        DataValueDescriptor dvd;
        long val;
        if (this.offset != null && (val = (dvd = this.offset.getValue()).getLong()) < 0L) {
            throw StandardException.newException("2201X", Long.toString(val));
        }
        if (this.fetchFirst != null && (val = (dvd = this.fetchFirst.getValue()).getLong()) < 1L) {
            throw StandardException.newException("2201W", Long.toString(val));
        }
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    protected ArrayList getSessionSchemaTableNamesForCursor() throws StandardException {
        FromList fromList = this.resultSet.getFromList();
        int fromListSize = fromList.size();
        ArrayList<String> sessionSchemaTableNames = null;
        for (int i = 0; i < fromListSize; ++i) {
            FromTable fromTable = (FromTable)fromList.elementAt(i);
            if (!(fromTable instanceof FromBaseTable) || !this.isSessionSchema(fromTable.getTableDescriptor().getSchemaDescriptor())) continue;
            if (sessionSchemaTableNames == null) {
                sessionSchemaTableNames = new ArrayList<String>();
            }
            sessionSchemaTableNames.add(fromTable.getTableName().getTableName());
        }
        return sessionSchemaTableNames;
    }

    private int determineUpdateMode(DataDictionary dataDictionary) throws StandardException {
        if (this.updateMode == 1) {
            return 1;
        }
        if (this.orderByList != null) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor has order by");
            return 1;
        }
        if (!this.resultSet.isUpdatableCursor(dataDictionary)) {
            return 1;
        }
        this.updateTable = this.resultSet.getCursorTargetTable();
        if (this.updateTable.markAsCursorTargetTable()) {
            this.needTarget = true;
            this.genTargetResultColList();
        }
        return 2;
    }

    public void optimizeStatement() throws StandardException {
        if (this.orderByList != null) {
            if (this.orderByList.size() > 1) {
                this.orderByList.removeDupColumns();
            }
            this.resultSet.pushOrderByList(this.orderByList);
            this.orderByList = null;
        }
        super.optimizeStatement(this.offset, this.fetchFirst);
    }

    int activationKind() {
        return 4;
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.indexOfSessionTableNamesInSavedObjects != -1) {
            MethodBuilder constructor = acb.getConstructor();
            constructor.pushThis();
            constructor.push(this.indexOfSessionTableNamesInSavedObjects);
            constructor.putField("org.apache.derby.impl.sql.execute.BaseActivation", "indexOfSessionTableNamesInSavedObjects", "int");
            constructor.endStatement();
        }
        this.generateParameterValueSet(acb);
        this.resultSet.markStatementResultSet();
        this.generateAuthorizeCheck(acb, mb, 1);
        this.resultSet.generate(acb, mb);
        if (this.needTarget) {
            acb.rememberCursor(mb);
            acb.addCursorPositionCode();
        }
    }

    public String getUpdateBaseTableName() {
        return this.updateTable == null ? null : this.updateTable.getBaseTableName();
    }

    public String getUpdateExposedTableName() throws StandardException {
        return this.updateTable == null ? null : this.updateTable.getExposedName();
    }

    public String getUpdateSchemaName() throws StandardException {
        return this.updateTable == null ? null : ((FromBaseTable)this.updateTable).getTableNameField().getSchemaName();
    }

    public int getUpdateMode() {
        return this.updateMode;
    }

    private String[] getUpdatableColumns() {
        return this.updatableColumns == null ? (String[])null : this.getUpdateColumnNames();
    }

    private ResultColumnDescriptor[] genTargetResultColList() throws StandardException {
        if (this.updateTable == null) {
            return null;
        }
        if (this.targetColumnDescriptors != null) {
            return this.targetColumnDescriptors;
        }
        ResultColumnList newList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ResultColumnList rcl = this.updateTable.getResultColumns();
        int rclSize = rcl.size();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn origCol = (ResultColumn)rcl.elementAt(index);
            ValueNode newNode = (ValueNode)this.getNodeFactory().getNode(94, origCol.getName(), this.makeTableName(origCol.getSchemaName(), origCol.getTableName()), origCol.getTypeServices(), this.getContextManager());
            ResultColumn newCol = (ResultColumn)this.getNodeFactory().getNode(80, origCol.columnDescriptor, newNode, this.getContextManager());
            newList.addResultColumn(newCol);
        }
        this.targetColumnDescriptors = newList.makeResultDescriptors();
        return this.targetColumnDescriptors;
    }

    public boolean needsSavepoint() {
        return false;
    }

    public Object getCursorInfo() throws StandardException {
        if (!this.needTarget) {
            return null;
        }
        return new CursorInfo(this.updateMode, new CursorTableReference(this.getUpdateExposedTableName(), this.getUpdateBaseTableName(), this.getUpdateSchemaName()), this.genTargetResultColList(), this.getUpdatableColumns());
    }

    private void bindUpdateColumns(FromTable targetTable) throws StandardException {
        int size = this.updatableColumns.size();
        ResultColumnList rcls = this.resultSet.getResultColumns();
        for (int index = 0; index < size; ++index) {
            String columnName = (String)this.updatableColumns.elementAt(index);
            TableDescriptor tableDescriptor = targetTable.getTableDescriptor();
            if (tableDescriptor.getColumnDescriptor(columnName) == null) {
                throw StandardException.newException("42X04", columnName);
            }
            for (int rclsIndex = 0; rclsIndex < rcls.size(); ++rclsIndex) {
                ResultColumn rc = (ResultColumn)rcls.elementAt(rclsIndex);
                if (rc.getSourceTableName() == null || rc.getExpression() == null || !rc.getExpression().getColumnName().equals(columnName) || rc.getName().equals(columnName)) continue;
                throw StandardException.newException("42X42", columnName);
            }
        }
    }

    private String[] getUpdateColumnNames() {
        int size = this.updatableColumns.size();
        if (size == 0) {
            return null;
        }
        Object[] names = new String[size];
        this.updatableColumns.copyInto(names);
        return names;
    }

    public String getXML() {
        return null;
    }
}

