/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HalfOuterJoinNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class FromList
extends QueryTreeNodeVector
implements OptimizableList {
    Properties properties;
    boolean fixedJoinOrder = true;
    boolean useStatistics = true;
    private boolean referencesSessionSchema;
    private boolean isTransparent;

    public void init(Object optimizeJoinOrder) {
        this.fixedJoinOrder = (Boolean)optimizeJoinOrder == false;
        this.isTransparent = false;
    }

    public void init(Object optimizeJoinOrder, Object fromTable) throws StandardException {
        this.init(optimizeJoinOrder);
        this.addFromTable((FromTable)fromTable);
    }

    public Optimizable getOptimizable(int index) {
        return (Optimizable)((Object)this.elementAt(index));
    }

    public void setOptimizable(int index, Optimizable optimizable) {
        this.setElementAt((FromTable)optimizable, index);
    }

    public void verifyProperties(DataDictionary dDictionary) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((Optimizable)((Object)this.elementAt(index))).verifyProperties(dDictionary);
        }
    }

    public void addFromTable(FromTable fromTable) throws StandardException {
        TableName leftTable = null;
        TableName rightTable = null;
        if (!(fromTable instanceof TableOperatorNode)) {
            int size = this.size();
            for (int index = 0; index < size; ++index) {
                leftTable = fromTable.getTableName();
                if ((FromTable)this.elementAt(index) instanceof TableOperatorNode || !leftTable.equals(rightTable = ((FromTable)this.elementAt(index)).getTableName())) continue;
                throw StandardException.newException("42X09", fromTable.getExposedName());
            }
        }
        this.addElement(fromTable);
    }

    public boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        boolean found = false;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            if (!fromTable.referencesTarget(name, baseTable)) continue;
            found = true;
            break;
        }
        return found;
    }

    public boolean referencesSessionSchema() throws StandardException {
        boolean found = false;
        if (this.referencesSessionSchema) {
            return true;
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            if (!fromTable.referencesSessionSchema()) continue;
            found = true;
            break;
        }
        return found;
    }

    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        boolean found = false;
        FromTable result = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            result = fromTable.getFromTableByName(name, schemaName, exactMatch);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public void bindTables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        ResultSetNode newNode;
        FromTable fromTable;
        int index;
        int size = this.size();
        for (index = 0; index < size; ++index) {
            fromTable = (FromTable)this.elementAt(index);
            newNode = fromTable.bindNonVTITables(dataDictionary, fromListParam);
            if (fromTable.referencesSessionSchema()) {
                this.referencesSessionSchema = true;
            }
            this.setElementAt(newNode, index);
        }
        for (index = 0; index < size; ++index) {
            fromTable = (FromTable)this.elementAt(index);
            newNode = fromTable.bindVTITables(fromListParam);
            if (fromTable.referencesSessionSchema()) {
                this.referencesSessionSchema = true;
            }
            this.setElementAt(newNode, index);
        }
    }

    public void bindExpressions(FromList fromListParam) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.bindExpressions(this.isTransparent ? fromListParam : this);
        }
    }

    public void bindResultColumns(FromList fromListParam) throws StandardException {
        int origList = fromListParam.size();
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            if (fromTable.needsSpecialRCLBinding()) {
                fromTable.bindResultColumns(fromListParam);
            }
            fromListParam.insertElementAt(fromTable, 0);
        }
        while (fromListParam.size() > origList) {
            fromListParam.removeElementAt(0);
        }
    }

    public boolean hasOuterJoins() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            if (!(fromTable instanceof HalfOuterJoinNode)) continue;
            return true;
        }
        return false;
    }

    public ResultColumnList expandAll(TableName allTableName) throws StandardException {
        FromTable fromTable;
        ResultColumnList resultColumnList = null;
        ResultColumnList tempRCList = null;
        boolean matchfound = false;
        int targetNestingLevel = ((FromTable)this.elementAt(0)).getLevel();
        int size = this.size();
        int prevNL = targetNestingLevel;
        for (int i = 1; i < size; ++i) {
            int currNL = ((FromTable)this.elementAt(i)).getLevel();
            SanityManager.ASSERT(prevNL >= currNL, "FROM list should have been ordered by nesting level (deepest level first), but it was not.");
            prevNL = currNL;
        }
        for (int index = 0; index < size && targetNestingLevel == (fromTable = (FromTable)this.elementAt(index)).getLevel(); ++index) {
            tempRCList = fromTable.getAllResultColumns(allTableName);
            if (tempRCList == null) continue;
            if (resultColumnList == null) {
                resultColumnList = tempRCList;
            } else {
                resultColumnList.nondestructiveAppend(tempRCList);
            }
            if (allTableName == null) continue;
            matchfound = true;
        }
        if (resultColumnList == null) {
            throw StandardException.newException("42X10", allTableName);
        }
        return resultColumnList;
    }

    public ResultColumn bindColumnReference(ColumnReference columnReference) throws StandardException {
        FromTable fromTable;
        boolean columnNameMatch = false;
        boolean tableNameMatch = false;
        int currentLevel = -1;
        int previousLevel = -1;
        ResultColumn matchingRC = null;
        String crTableName = columnReference.getTableName();
        int size = this.size();
        for (int index = 0; index < size && (previousLevel == (currentLevel = (fromTable = (FromTable)this.elementAt(index)).getLevel()) || !columnNameMatch && !tableNameMatch); ++index) {
            previousLevel = currentLevel;
            ResultColumn resultColumn = fromTable.getMatchingColumn(columnReference);
            if (resultColumn != null) {
                if (!columnNameMatch) {
                    matchingRC = resultColumn;
                    columnReference.setSource(resultColumn);
                    columnReference.setNestingLevel(((FromTable)this.elementAt(0)).getLevel());
                    columnReference.setSourceLevel(currentLevel);
                    columnNameMatch = true;
                    if (fromTable.isPrivilegeCollectionRequired()) {
                        this.getCompilerContext().addRequiredColumnPriv(resultColumn.getTableColumnDescriptor());
                    }
                } else {
                    throw StandardException.newException("42X03", columnReference.getSQLColumnName());
                }
            }
            tableNameMatch = tableNameMatch || crTableName != null && crTableName.equals(fromTable.getExposedName());
        }
        return matchingRC;
    }

    public void rejectParameters() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.rejectParameters();
        }
    }

    public boolean LOJ_reorderable(int numTables) throws StandardException {
        boolean anyChange = false;
        if (this.size() > 1) {
            return anyChange;
        }
        FromTable ft = (FromTable)this.elementAt(0);
        anyChange = ft.LOJ_reorderable(numTables);
        return anyChange;
    }

    public void preprocess(int numTables, GroupByList gbl, ValueNode predicateTree) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable ft = (FromTable)this.elementAt(index);
            ft = ft.transformOuterJoins(predicateTree, numTables);
            this.setElementAt(ft.preprocess(numTables, gbl, this), index);
        }
    }

    public void flattenFromTables(ResultColumnList rcl, PredicateList predicateList, SubqueryList sql, GroupByList gbl) throws StandardException {
        FromTable ft;
        boolean flattened = true;
        Vector<Integer> flattenedTableNumbers = new Vector<Integer>();
        SanityManager.ASSERT(rcl != null, "rcl is expected to be non-null");
        SanityManager.ASSERT(predicateList != null, "predicateList is expected to be non-null");
        SanityManager.ASSERT(sql != null, "sql is expected to be non-null");
        while (flattened) {
            flattened = false;
            for (int index = 0; index < this.size() && !flattened; ++index) {
                ft = (FromTable)this.elementAt(index);
                if (!(ft instanceof FromSubquery) && !ft.isFlattenableJoinNode()) continue;
                flattenedTableNumbers.addElement(new Integer(ft.getTableNumber()));
                FromList flatteningFL = ft.flatten(rcl, predicateList, sql, gbl);
                SanityManager.ASSERT(flatteningFL == null || flatteningFL.size() > 0, "flatteningFL expected to be null or size > 0");
                if (flatteningFL != null) {
                    this.setElementAt(flatteningFL.elementAt(0), index);
                    int innerSize = flatteningFL.size();
                    for (int inner = 1; inner < innerSize; ++inner) {
                        this.insertElementAt(flatteningFL.elementAt(inner), index + inner);
                    }
                } else {
                    this.removeElementAt(index);
                }
                flattened = true;
            }
        }
        if (flattenedTableNumbers.size() > 0) {
            for (int i = 0; i < this.size(); ++i) {
                ResultSetNode rst;
                ft = (FromTable)this.elementAt(i);
                if (!(ft instanceof ProjectRestrictNode) || !((rst = ((ProjectRestrictNode)ft).getChildResult()) instanceof FromBaseTable)) continue;
                ((FromBaseTable)rst).clearDependency(flattenedTableNumbers);
            }
        }
    }

    void pushPredicates(PredicateList predicateList) throws StandardException {
        SanityManager.ASSERT(predicateList != null, "predicateList is expected to be non-null");
        predicateList.categorize();
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.pushExpressions(predicateList);
        }
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.treePrint(depth + 1);
        }
    }

    public void setLevel(int level) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.setLevel(level);
        }
    }

    public FromTable getFromTableByResultColumn(ResultColumn rc) {
        FromTable fromTable = null;
        int size = this.size();
        for (int index = 0; index < size && (fromTable = (FromTable)this.elementAt(index)).getResultColumns().indexOf(rc) == -1; ++index) {
        }
        SanityManager.ASSERT(fromTable != null, "No matching FromTable found");
        return fromTable;
    }

    public void setProperties(Properties props) throws StandardException {
        this.properties = props;
        Enumeration<Object> e = this.properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.properties.get(key);
            if (key.equals("joinOrder")) {
                if (StringUtil.SQLEqualsIgnoreCase(value, "fixed")) {
                    this.fixedJoinOrder = true;
                    continue;
                }
                if (StringUtil.SQLEqualsIgnoreCase(value, "unfixed")) {
                    this.fixedJoinOrder = false;
                    continue;
                }
                throw StandardException.newException("42X17", value);
            }
            if (key.equals("useStatistics")) {
                if (StringUtil.SQLEqualsIgnoreCase(value, "true")) {
                    this.useStatistics = true;
                    continue;
                }
                if (StringUtil.SQLEqualsIgnoreCase(value, "false")) {
                    this.useStatistics = false;
                    continue;
                }
                throw StandardException.newException("42X64", value);
            }
            throw StandardException.newException("42X41", (Object)key, (Object)value);
        }
    }

    public void reOrder(int[] joinOrder) {
        int posn;
        if (joinOrder.length != this.size()) {
            SanityManager.THROWASSERT("In reOrder(), size of FromList is " + this.size() + " while size of joinOrder array is " + joinOrder.length);
        }
        int sum = 0;
        for (int i = 0; i < joinOrder.length; ++i) {
            if (joinOrder[i] < 0 || joinOrder[i] > joinOrder.length - 1) {
                SanityManager.THROWASSERT("joinOrder[" + i + "] == " + joinOrder[i] + " is out of range - must be between 0 and " + (joinOrder.length - 1) + " inclusive.");
            }
            sum += joinOrder[i];
        }
        if (sum != joinOrder.length * (joinOrder.length - 1) / 2) {
            String arrayVals = "";
            for (int i = 0; i < joinOrder.length; ++i) {
                arrayVals = arrayVals + joinOrder[i] + " ";
            }
            SanityManager.THROWASSERT("joinOrder array has some duplicate value: " + arrayVals);
        }
        FromTable[] orderedFL = new FromTable[joinOrder.length];
        for (posn = 0; posn < joinOrder.length; ++posn) {
            orderedFL[posn] = this.elementAt(joinOrder[posn]);
        }
        for (posn = 0; posn < joinOrder.length; ++posn) {
            this.setElementAt(orderedFL[posn], posn);
        }
    }

    public boolean useStatistics() {
        return this.useStatistics;
    }

    public boolean optimizeJoinOrder() {
        return !this.fixedJoinOrder;
    }

    public boolean legalJoinOrder(int numTablesInQuery) {
        JBitSet assignedTableMap = new JBitSet(numTablesInQuery);
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable ft = (FromTable)this.elementAt(index);
            assignedTableMap.or(ft.getReferencedTableMap());
            if (ft.legalJoinOrder(assignedTableMap)) continue;
            return false;
        }
        return true;
    }

    public void initAccessPaths(Optimizer optimizer) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable ft = (FromTable)this.elementAt(index);
            ft.initAccessPaths(optimizer);
        }
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList bindingRCL) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.bindUntypedNullsToResultColumns(bindingRCL);
        }
    }

    void decrementLevel(int decrement) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.decrementLevel(decrement);
            ProjectRestrictNode prn = (ProjectRestrictNode)fromTable;
            PredicateList pl = prn.getRestrictionList();
            if (pl == null) continue;
            pl.decrementLevel(this, decrement);
        }
    }

    boolean returnsAtMostSingleRow(ResultColumnList rcl, ValueNode whereClause, PredicateList wherePredicates, DataDictionary dd) throws StandardException {
        ResultColumn rc;
        boolean satisfiesOuter = false;
        ColumnReference additionalCR = null;
        PredicateList predicatesTemp = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        int wherePredicatesSize = wherePredicates.size();
        for (int index = 0; index < wherePredicatesSize; ++index) {
            predicatesTemp.addPredicate((Predicate)wherePredicates.elementAt(index));
        }
        if (rcl != null && (rc = (ResultColumn)rcl.elementAt(0)).getExpression() instanceof ColumnReference) {
            additionalCR = (ColumnReference)rc.getExpression();
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            if (!(fromTable instanceof ProjectRestrictNode)) {
                return false;
            }
            ProjectRestrictNode prn = (ProjectRestrictNode)fromTable;
            if (!(prn.getChildResult() instanceof FromBaseTable)) {
                return false;
            }
            FromBaseTable fbt = (FromBaseTable)prn.getChildResult();
            if (!fbt.getExistsBaseTable()) continue;
            int existsTableNumber = fbt.getTableNumber();
            int predicatesTempSize = predicatesTemp.size();
            block2: for (int predicatesTempIndex = predicatesTempSize - 1; predicatesTempIndex >= 0; --predicatesTempIndex) {
                AndNode topAndNode;
                ValueNode whereWalker = topAndNode = ((Predicate)predicatesTemp.elementAt(predicatesTempIndex)).getAndNode();
                while (whereWalker instanceof AndNode) {
                    JBitSet referencedTables;
                    AndNode and = whereWalker;
                    if (and.getLeftOperand().isRelationalOperator() && ((RelationalOperator)((Object)and.getLeftOperand())).getOperator() == 1 && (referencedTables = and.getLeftOperand().getTablesReferenced()).get(existsTableNumber)) {
                        predicatesTemp.removeElementAt(predicatesTempIndex);
                        continue block2;
                    }
                    whereWalker = whereWalker.getRightOperand();
                }
            }
        }
        int[] tableNumbers = this.getTableNumbers();
        JBitSet[][] tableColMap = new JBitSet[size][size];
        boolean[] oneRow = new boolean[size];
        boolean oneRowResult = false;
        for (int index = 0; index < size; ++index) {
            ProjectRestrictNode prn = (ProjectRestrictNode)this.elementAt(index);
            FromBaseTable fbt = (FromBaseTable)prn.getChildResult();
            if (fbt.getExistsBaseTable()) {
                oneRow[index] = true;
                continue;
            }
            int numColumns = fbt.getTableDescriptor().getNumberOfColumns();
            boolean[] eqOuterCols = new boolean[numColumns + 1];
            int tableNumber = fbt.getTableNumber();
            boolean resultColTable = false;
            for (int i = 0; i < size; ++i) {
                tableColMap[index][i] = new JBitSet(numColumns + 1);
            }
            if (additionalCR != null && additionalCR.getTableNumber() == tableNumber) {
                rcl.recordColumnReferences(eqOuterCols, tableColMap[index], index);
                resultColTable = true;
            }
            if (whereClause != null) {
                whereClause.checkTopPredicatesForEqualsConditions(tableNumber, eqOuterCols, tableNumbers, tableColMap[index], resultColTable);
            }
            predicatesTemp.checkTopPredicatesForEqualsConditions(tableNumber, eqOuterCols, tableNumbers, tableColMap[index], resultColTable);
            if (prn.getRestrictionList() != null) {
                prn.getRestrictionList().checkTopPredicatesForEqualsConditions(tableNumber, eqOuterCols, tableNumbers, tableColMap[index], resultColTable);
            }
            if (!fbt.supersetOfUniqueIndex(tableColMap[index])) {
                return false;
            }
            oneRowResult = fbt.supersetOfUniqueIndex(eqOuterCols);
            if (!oneRowResult) continue;
            oneRow[index] = true;
            satisfiesOuter = true;
        }
        if (satisfiesOuter) {
            boolean foundOneRow = true;
            while (foundOneRow) {
                foundOneRow = false;
                for (int index = 0; index < size; ++index) {
                    if (!oneRow[index]) continue;
                    for (int i = 0; i < size; ++i) {
                        if (oneRow[i] || !tableColMap[i][index].get(0)) continue;
                        oneRow[i] = true;
                        foundOneRow = true;
                    }
                }
            }
            for (int index = 0; index < size; ++index) {
                if (oneRow[index]) continue;
                satisfiesOuter = false;
                break;
            }
        }
        return satisfiesOuter;
    }

    int[] getTableNumbers() {
        int size = this.size();
        int[] tableNumbers = new int[size];
        for (int index = 0; index < size; ++index) {
            ProjectRestrictNode prn = (ProjectRestrictNode)this.elementAt(index);
            if (!(prn.getChildResult() instanceof FromTable)) continue;
            FromTable ft = (FromTable)prn.getChildResult();
            tableNumbers[index] = ft.getTableNumber();
        }
        return tableNumbers;
    }

    void genExistsBaseTables(JBitSet referencedTableMap, FromList outerFromList, boolean isNotExists) throws StandardException {
        int index;
        JBitSet dependencyMap = (JBitSet)referencedTableMap.clone();
        if (this.size() != 1) {
            SanityManager.THROWASSERT("size() expected to be 1, not " + this.size());
        }
        int size = this.size();
        for (index = 0; index < size; ++index) {
            ResultSetNode ft = ((ProjectRestrictNode)this.elementAt(index)).getChildResult();
            if (!(ft instanceof FromTable)) continue;
            dependencyMap.clear(((FromTable)ft).getTableNumber());
        }
        if (dependencyMap.getFirstSetBit() == -1) {
            int outerSize = outerFromList.size();
            for (int outer = 0; outer < outerSize; ++outer) {
                dependencyMap.or(((FromTable)outerFromList.elementAt(outer)).getReferencedTableMap());
            }
        }
        for (index = 0; index < size; ++index) {
            ProjectRestrictNode prn;
            FromTable fromTable = (FromTable)this.elementAt(index);
            if (!(fromTable instanceof ProjectRestrictNode) || !((prn = (ProjectRestrictNode)fromTable).getChildResult() instanceof FromBaseTable)) continue;
            FromBaseTable fbt = (FromBaseTable)prn.getChildResult();
            fbt.setExistsBaseTable(true, (JBitSet)dependencyMap.clone(), isNotExists);
        }
    }

    boolean tableNumberIsNotExists(int tableNumber) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable ft;
            ProjectRestrictNode prn = (ProjectRestrictNode)this.elementAt(index);
            if (!(prn.getChildResult() instanceof FromTable) || (ft = (FromTable)prn.getChildResult()).getTableNumber() != tableNumber) continue;
            return ft.isNotExists();
        }
        return false;
    }

    public int updateTargetLockMode() {
        if (this.size() != 1) {
            SanityManager.THROWASSERT("size() expected to be 1");
        }
        return ((ResultSetNode)this.elementAt(0)).updateTargetLockMode();
    }

    boolean hashJoinSpecified() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable ft = (FromTable)this.elementAt(index);
            String joinStrategy = ft.getUserSpecifiedJoinStrategy();
            if (joinStrategy == null || !StringUtil.SQLToUpperCase(joinStrategy).equals("HASH")) continue;
            return true;
        }
        return false;
    }

    void markAsTransparent() {
        this.isTransparent = true;
    }

    public Visitable accept(Visitor v) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            this.setElementAt((QueryTreeNode)fromTable.accept(v), index);
        }
        return this;
    }
}

