/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.SystemAggregator;

abstract class OrderableAggregator
extends SystemAggregator {
    protected DataValueDescriptor value;

    OrderableAggregator() {
    }

    public void setup(String aggregateName) {
    }

    public void merge(ExecAggregator addend) throws StandardException {
        SanityManager.ASSERT(addend instanceof OrderableAggregator, "addend is supposed to be the same type of aggregator for the merge operator");
        DataValueDescriptor bv = ((OrderableAggregator)addend).value;
        if (bv != null) {
            this.accumulate(bv);
        }
    }

    public DataValueDescriptor getResult() throws StandardException {
        return this.value;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.value = (DataValueDescriptor)in.readObject();
    }
}

