/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class SetConstraintsConstantAction
extends DDLConstantAction {
    private boolean enable;
    private boolean unconditionallyEnforce;
    private ConstraintDescriptorList cdl;
    private UUID[] cuuids;
    private UUID[] tuuids;

    SetConstraintsConstantAction(ConstraintDescriptorList cdl, boolean enable, boolean unconditionallyEnforce) {
        this.cdl = cdl;
        this.enable = enable;
        this.unconditionallyEnforce = unconditionallyEnforce;
    }

    public String toString() {
        return "SET CONSTRAINTS";
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        ConstraintDescriptorList tmpCdl = this.getConstraintDescriptorList(dd);
        int[] enabledCol = new int[]{6};
        dd.startWriting(lcc);
        this.publishToTargets(activation);
        boolean skipFKs = false;
        if (tmpCdl == null) {
            skipFKs = true;
            tmpCdl = dd.getConstraintDescriptors(null);
        }
        Hashtable<UUID, ConstraintDescriptorList> checkConstraintTables = null;
        int cdlSize = tmpCdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            boolean enforceThisConstraint;
            ConstraintDescriptor cd = tmpCdl.elementAt(index);
            if (this.unconditionallyEnforce) {
                enforceThisConstraint = true;
            } else {
                boolean bl = enforceThisConstraint = this.enable && !cd.isEnabled();
            }
            if (enforceThisConstraint) {
                if (cd instanceof ForeignKeyConstraintDescriptor) {
                    this.validateFKConstraint((ForeignKeyConstraintDescriptor)cd, dd, tc, lcc.getContextManager());
                } else if (cd instanceof CheckConstraintDescriptor) {
                    ConstraintDescriptorList tabCdl;
                    TableDescriptor td = cd.getTableDescriptor();
                    if (checkConstraintTables == null) {
                        checkConstraintTables = new Hashtable<UUID, ConstraintDescriptorList>(10);
                    }
                    if ((tabCdl = (ConstraintDescriptorList)checkConstraintTables.get(td.getUUID())) == null) {
                        tabCdl = new ConstraintDescriptorList();
                        checkConstraintTables.put(td.getUUID(), tabCdl);
                    }
                    tabCdl.add(cd);
                }
                dm.invalidateFor(cd.getTableDescriptor(), 20, lcc);
                cd.setEnabled();
                dd.updateConstraintDescriptor(cd, cd.getUUID(), enabledCol, tc);
            }
            if (!skipFKs && cd instanceof ReferencedKeyConstraintDescriptor) {
                ReferencedKeyConstraintDescriptor refcd = (ReferencedKeyConstraintDescriptor)cd;
                ConstraintDescriptorList fkcdl = refcd.getForeignKeyConstraints(3);
                int fkcdlSize = fkcdl.size();
                for (int inner = 0; inner < fkcdlSize; ++inner) {
                    ForeignKeyConstraintDescriptor fkcd = (ForeignKeyConstraintDescriptor)fkcdl.elementAt(inner);
                    if (this.enable && !fkcd.isEnabled()) {
                        dm.invalidateFor(fkcd.getTableDescriptor(), 20, lcc);
                        this.validateFKConstraint(fkcd, dd, tc, lcc.getContextManager());
                        fkcd.setEnabled();
                        dd.updateConstraintDescriptor(fkcd, fkcd.getUUID(), enabledCol, tc);
                        continue;
                    }
                    if (this.enable || !fkcd.isEnabled()) continue;
                    dm.invalidateFor(fkcd, 21, lcc);
                    fkcd.setDisabled();
                    dd.updateConstraintDescriptor(fkcd, fkcd.getUUID(), enabledCol, tc);
                }
            }
            if (this.enable || !cd.isEnabled()) continue;
            dm.invalidateFor(cd, 21, lcc);
            cd.setDisabled();
            dd.updateConstraintDescriptor(cd, cd.getUUID(), enabledCol, tc);
        }
        this.validateAllCheckConstraints(lcc, checkConstraintTables);
    }

    private void validateAllCheckConstraints(LanguageConnectionContext lcc, Hashtable ht) throws StandardException {
        CheckConstraintDescriptor cd = null;
        if (ht == null) {
            return;
        }
        Enumeration e = ht.elements();
        while (e.hasMoreElements()) {
            ConstraintDescriptorList cdl = (ConstraintDescriptorList)e.nextElement();
            StringBuffer text = null;
            StringBuffer constraintNames = null;
            int cdlSize = cdl.size();
            for (int index = 0; index < cdlSize; ++index) {
                cd = (CheckConstraintDescriptor)cdl.elementAt(index);
                if (text == null) {
                    text = new StringBuffer("(").append(((ConstraintDescriptor)cd).getConstraintText()).append(") ");
                    constraintNames = new StringBuffer(cd.getConstraintName());
                    continue;
                }
                text.append(" AND (").append(((ConstraintDescriptor)cd).getConstraintText()).append(") ");
                constraintNames.append(", ").append(cd.getConstraintName());
            }
            SanityManager.ASSERT(text != null, "internal error, badly built hastable");
            ConstraintConstantAction.validateConstraint(constraintNames.toString(), text.toString(), cd.getTableDescriptor(), lcc, true);
        }
    }

    private void validateFKConstraint(ForeignKeyConstraintDescriptor fk, DataDictionary dd, TransactionController tc, ContextManager cm) throws StandardException {
        IndexRowGenerator irg = fk.getIndexConglomerateDescriptor(dd).getIndexDescriptor();
        ExecIndexRow indexTemplateRow = irg.getIndexRowTemplate();
        TableDescriptor td = fk.getTableDescriptor();
        ExecRow baseRow = td.getEmptyExecRow();
        irg.getIndexRow(baseRow, this.getRowLocation(dd, td, tc), indexTemplateRow, null);
        ConstraintConstantAction.validateFKConstraint(tc, dd, fk, fk.getReferencedConstraint(), indexTemplateRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowLocation getRowLocation(DataDictionary dd, TableDescriptor td, TransactionController tc) throws StandardException {
        RowLocation rl;
        ConglomerateController heapCC = null;
        long tableId = td.getHeapConglomerateId();
        heapCC = tc.openConglomerate(tableId, false, 0, 6, 2);
        try {
            rl = heapCC.newRowLocationTemplate();
        }
        finally {
            heapCC.close();
        }
        return rl;
    }

    private ConstraintDescriptorList getConstraintDescriptorList(DataDictionary dd) throws StandardException {
        if (this.cdl != null) {
            return this.cdl;
        }
        if (this.tuuids == null) {
            return null;
        }
        this.cdl = new ConstraintDescriptorList();
        for (int i = 0; i < this.tuuids.length; ++i) {
            ConstraintDescriptor cd;
            TableDescriptor td = dd.getTableDescriptor(this.tuuids[i]);
            if (td == null) {
                SanityManager.THROWASSERT("couldn't locate table descriptor in SET CONSTRAINTS for uuid " + this.tuuids[i]);
            }
            if ((cd = dd.getConstraintDescriptorById(td, this.cuuids[i])) == null) {
                SanityManager.THROWASSERT("couldn't locate constraint descriptor  in SET CONSTRAINTS for uuid " + this.cuuids[i]);
            }
            this.cdl.add(cd);
        }
        return this.cdl;
    }

    protected void publishToTargets(Activation activation) throws StandardException {
    }
}

