/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.smlif.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.rm.internal.smlif.SMLImages;
import org.eclipse.cosmos.rm.internal.smlif.common.SMLMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class ResourceSelectionDialog
extends Dialog {
    private Shell sShell = new Shell(this.getParent(), 67680);
    private IFile[] selectedFiles;
    private int contentType;
    private boolean multiSelection;
    private String title;
    private String message;

    public ResourceSelectionDialog(Shell parent, int contentType) {
        super(parent);
        this.contentType = contentType;
        this.multiSelection = false;
    }

    public IFile[] open() {
        Point shellBounds = new Point(370, 456);
        this.sShell.setText(this.getTitle() == null ? SMLMessages.dialogResourceTitle : this.getTitle());
        this.sShell.setLayout((Layout)new GridLayout());
        this.sShell.setSize(shellBounds);
        this.sShell.setLocation(this.getParent().getDisplay().getBounds().width / 2 - shellBounds.x / 2, this.getParent().getClientArea().height / 2 - shellBounds.y / 2);
        this.sShell.setImage(SMLImages.INSTANCE.getImage("resource.gif"));
        this.createContent();
        this.sShell.open();
        Display display = this.getParent().getDisplay();
        while (!this.sShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.dispose();
        return this.selectedFiles;
    }

    public void dispose() {
        if (this.sShell != null) {
            this.sShell.dispose();
            this.sShell = null;
        }
    }

    private void createContent() {
        Composite composite = new Composite((Composite)this.sShell, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label selectLabel = new Label(composite, 0);
        selectLabel.setText(this.getMessage() == null ? (this.isMultiSelection() ? SMLMessages.dialogResourceQuestion : SMLMessages.dialogResourceQuestion1) : this.getMessage());
        selectLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        Tree resourceTree = new Tree(composite, 0x800 | (this.isMultiSelection() ? 2 : 0));
        resourceTree.setLayout((Layout)new GridLayout());
        resourceTree.setLayoutData((Object)new GridData(4, 4, true, true));
        final TreeViewer resourceTreeViewer = new TreeViewer(resourceTree);
        resourceTreeViewer.setContentProvider((IContentProvider)new ResourceTreeContentProvider(this.contentType));
        resourceTreeViewer.setLabelProvider((IBaseLabelProvider)new ResourceTreeLabelProvider());
        resourceTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        Composite buttonComposite = new Composite((Composite)this.sShell, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, true));
        buttonComposite.setLayoutData((Object)new GridData(131072, -1, true, false));
        final Button okButton = this.createButton(buttonComposite, SMLMessages.commonOK);
        Button cancelButton = this.createButton(buttonComposite, SMLMessages.commonCancel);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == okButton) {
                    StructuredSelection selection = (StructuredSelection)resourceTreeViewer.getSelection();
                    Object[] selectedObjects = selection.toArray();
                    ArrayList<IFile> fileList = new ArrayList<IFile>();
                    int i = 0;
                    while (i < selectedObjects.length) {
                        if (selectedObjects[i] instanceof IFile) {
                            fileList.add((IFile)selectedObjects[i]);
                        }
                        ++i;
                    }
                    ResourceSelectionDialog.this.selectedFiles = fileList.toArray(new IFile[fileList.size()]);
                } else {
                    ResourceSelectionDialog.this.selectedFiles = new IFile[0];
                }
                ResourceSelectionDialog.this.sShell.close();
            }
        };
        resourceTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty() || !(event.getSelection() instanceof StructuredSelection)) {
                    okButton.setEnabled(false);
                }
                Iterator selectedItems = ((StructuredSelection)event.getSelection()).iterator();
                while (selectedItems.hasNext()) {
                    if (!(selectedItems.next() instanceof IFile)) continue;
                    okButton.setEnabled(true);
                    return;
                }
                okButton.setEnabled(false);
            }
        });
        resourceTree.addSelectionListener((SelectionListener)new SelectionAdapter((SelectionListener)buttonListener){
            private final /* synthetic */ SelectionListener val$buttonListener;
            {
                this.val$buttonListener = selectionListener;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Event event = new Event();
                event.widget = okButton;
                this.val$buttonListener.widgetSelected(new SelectionEvent(event));
            }
        });
        okButton.addSelectionListener((SelectionListener)buttonListener);
        cancelButton.addSelectionListener((SelectionListener)buttonListener);
    }

    private Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 0);
        button.setText(text);
        GridData buttonGridData = new GridData();
        buttonGridData.widthHint = 80;
        button.setLayoutData((Object)buttonGridData);
        return button;
    }

    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    public void setMultiSelection(boolean multiSelection) {
        this.multiSelection = multiSelection;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private static class ResourceTreeContentProvider
    implements ITreeContentProvider {
        private IWorkspaceRoot input;
        private int contentType;

        public ResourceTreeContentProvider(int contentType) {
            this.contentType = contentType;
        }

        public Object[] getChildren(Object parent) {
            try {
                ArrayList<IResource> children = new ArrayList<IResource>();
                IResource[] resources = ((IContainer)parent).members();
                int i = 0;
                while (i < resources.length) {
                    if (resources[i] instanceof IContainer) {
                        children.add(resources[i]);
                    } else if (resources[i] instanceof IFile && this.contentType == SMLValidatorUtil.identifyDocumentType((IFile)((IFile)resources[i]))) {
                        children.add(resources[i]);
                    }
                    ++i;
                }
                return children.toArray();
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IContainer;
        }

        public Object[] getElements(Object inputElement) {
            if (this.input == null) {
                return new Object[0];
            }
            return this.input.getProjects();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = (IWorkspaceRoot)newInput;
        }
    }

    private static class ResourceTreeLabelProvider
    implements ILabelProvider {
        private ResourceTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IProject) {
                return SMLImages.INSTANCE.getImage("project.gif");
            }
            if (element instanceof IContainer) {
                return SMLImages.INSTANCE.getImage("folder.gif");
            }
            return SMLImages.INSTANCE.getImage("doc.gif");
        }

        public String getText(Object element) {
            return ((IResource)element).getName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

