/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

/**
 * Interface representing any constraint used in a template
 * 
 * 
 * @author David Whiteman
 */
public interface IConstraint {
	/**
	 * The instance ID constraint type
	 */
	public static final int INSTANCE_ID_CONSTRAINT = 0x00;

	/**
	 * The record type constraint type
	 */
	public static final int RECORD_TYPE = 0x01;

	/**
	 * The property value constraint type
	 */
	public static final int PROPERTY_VALUE = 0x02;

	/**
	 * The XPath expression type
	 */
	public static final int XPATH_EXPRESSION = 0x03;

	/**
	 * The record constraint type
	 */
	public static final int RECORD_CONSTRAINT = 0x04;

	/**
	 * Retrieves and returns the type of this constraint
	 * 
	 * @return The type of this constraint
	 */
	public int getType();
}
