/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.VersionRangeType;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.MaxVersionCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionRangeCompare {
    protected static Collection<VersionRangeType> merge(List<VersionRangeType> range, List<VersionRangeType> range2) {
        Vector<VersionRangeType> toRemove = new Vector<VersionRangeType>();
        for (VersionRangeType o1 : range) {
            for (VersionRangeType o2 : range2) {
                if (toRemove.contains(o2) || !VersionRangeCompare.equals(o1, o2)) continue;
                toRemove.add(o2);
                o1 = VersionRangeCompare.merge(o1, o2);
            }
        }
        range2.removeAll(toRemove);
        Vector<VersionRangeType> finals = new Vector<VersionRangeType>();
        finals.addAll(range);
        finals.addAll(range2);
        return finals;
    }

    protected static VersionRangeType merge(VersionRangeType o1, VersionRangeType o2) {
        ObjectFactory objectFactory = new ObjectFactory();
        VersionRangeType vr = objectFactory.createVersionRangeType();
        vr.getFixName().addAll(o1.getFixName());
        vr.getFixName().addAll(o2.getFixName());
        vr.setMaxVersion(o1.getMaxVersion());
        vr.setMinVersion(o1.getMinVersion());
        return vr;
    }

    protected static boolean equals(VersionRangeType vr, VersionRangeType vr2) {
        if (MaxVersionCompare.equals(vr.getMaxVersion(), vr2.getMaxVersion())) {
            return false;
        }
        return !StringCompare.equals(vr.getMinVersion(), vr2.getMinVersion());
    }
}

