/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.schema.marshal;

import java.io.File;
import java.io.InputStream;

import javax.xml.bind.JAXBElement;

public interface Marshaller {
	public <T> T unmarshal(Class<T> clazz, String filename) throws MarshallerException;
	
	public <T> T unmarshal(Class<T> clazz, File file) throws MarshallerException;
	
	public <T> T unmarshal(Class<T> clazz, InputStream is) throws MarshallerException;
	
	public <T> void marshal(Class<T> clazz, JAXBElement<T> t, String filename) throws MarshallerException;
}