/*******************************************************************************
 * Copyright (c) 2007,2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractServletHandler;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IServletHandler;

public class URLDelegator extends HttpServlet {
	static final long serialVersionUID = -5991590204597891023L;

	protected AbstractServletHandler outputter;
	protected List<IServletHandler> delegators;
	private static ILogger logger = LoggerWrapper.getLogger(URLDelegator.class);
	
	public URLDelegator() {
		super();
		setLogger();
	}

	@Override
	public void init(ServletConfig config) throws ServletException {
		
		String delegatorStr = config.getServletContext().getInitParameter( "DELEGATORS" ); //$NON-NLS-1$
		if (delegatorStr != null){
			String[] delegatorsStrings = delegatorStr.split(","); //$NON-NLS-1$
			delegators = new ArrayList();
			for (int x = 0; x < delegatorsStrings.length; x++){				
				try {
					IServletHandler delegator = (IServletHandler)Class.forName(delegatorsStrings[x]).newInstance();
					delegators.add(delegator);
					delegator.init(config);
				} catch (InstantiationException e) {
					logger.error(e);
				} catch (IllegalAccessException e) {
					logger.error(e);
				} catch (ClassNotFoundException e) {
					logger.error(e);
				}
			}
		}
		outputter = createOutputterDelegator();
		super.init(config);
		outputter.init(config);
	}

	protected AbstractServletHandler createOutputterDelegator(){
		return new OutputterDelegator();
	}
	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {	
		
		StringWriter sw = new StringWriter();
		
		outputter.doGet(req, sw);
		if (delegators != null){
			for (int x= 0; x < delegators.size(); x++){
				delegators.get(x).doGet(req, sw);
			}
		}
		
		sw.flush();
		PrintWriter fw = resp.getWriter();
		fw.append(sw.getBuffer().toString());
		fw.close();
		sw.close();
		
	}
	
	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
	//	resp.setContentType("application/json"); //$NON-NLS-1$
		StringWriter sw = new StringWriter();
		
		outputter.doPost(req, sw);
		if (delegators != null){
			for (int x= 0; x < delegators.size(); x++){
				delegators.get(x).doPost(req, sw);
			}
		}
		sw.flush();
		PrintWriter fw = resp.getWriter();
		fw.append(sw.getBuffer().toString());
		fw.close();
		sw.close();
				
	}
	
	protected void setLogger(){
		LoggerWrapper.setLogwrapper(new LoggerWrapper());
	}

}
