/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.timer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.Timer;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.timer.TimerFactory;

public class SingletonTimerFactory
implements TimerFactory,
ModuleControl {
    private Timer singletonTimer;

    public SingletonTimerFactory() {
        ClassLoader savecl = null;
        boolean hasGetClassLoaderPerms = false;
        try {
            savecl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            hasGetClassLoaderPerms = true;
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (hasGetClassLoaderPerms) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(null);
                        return null;
                    }
                });
            }
            catch (SecurityException se) {
                // empty catch block
            }
        }
        this.singletonTimer = new Timer(true);
        if (hasGetClassLoaderPerms) {
            try {
                final ClassLoader tmpsavecl = savecl;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(tmpsavecl);
                        return null;
                    }
                });
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public Timer getCancellationTimer() {
        return this.singletonTimer;
    }

    public void boot(boolean create, Properties properties) throws StandardException {
    }

    public void stop() {
        this.singletonTimer.cancel();
    }
}

