/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class GenerationClauseNode
extends ValueNode {
    private ValueNode _generationExpression;
    private String _expressionText;
    private ValueNode _boundExpression;
    private ProviderList _apl;

    public void init(Object generationExpression, Object expressionText) {
        this._generationExpression = (ValueNode)generationExpression;
        this._expressionText = (String)expressionText;
    }

    public String getExpressionText() {
        return this._expressionText;
    }

    void setAuxiliaryProviderList(ProviderList apl) {
        this._apl = apl;
    }

    public ProviderList getAuxiliaryProviderList() {
        return this._apl;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this._boundExpression = this._generationExpression.bindExpression(fromList, subqueryList, aggregateVector);
        return this._boundExpression;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    protected boolean isEquivalent(ValueNode other) throws StandardException {
        if (!(other instanceof GenerationClauseNode)) {
            return false;
        }
        GenerationClauseNode that = (GenerationClauseNode)other;
        return this._generationExpression.isEquivalent(that._generationExpression);
    }

    public Vector findReferencedColumns() throws StandardException {
        CollectNodesVisitor visitor = new CollectNodesVisitor(ColumnReference.class);
        this._generationExpression.accept(visitor);
        Vector result = visitor.getList();
        if (result == null) {
            result = new Vector();
        }
        return result;
    }

    public String toString() {
        return "GENERATED ALWAYS AS ( " + this._expressionText + " )";
    }
}

