/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.impl.sql.execute.NoRowsResultSetImpl;

class CallStatementResultSet
extends NoRowsResultSetImpl {
    private final GeneratedMethod methodCall;

    CallStatementResultSet(GeneratedMethod methodCall, Activation a) throws StandardException {
        super(a);
        this.methodCall = methodCall;
    }

    public void open() throws StandardException {
        this.setup();
        this.methodCall.invoke(this.activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws StandardException {
        super.close();
        ResultSet[][] dynamicResults = this.getActivation().getDynamicResults();
        if (dynamicResults != null) {
            StandardException errorOnClose = null;
            ConnectionContext jdbcContext = null;
            for (int i = 0; i < dynamicResults.length; ++i) {
                Object var10_9;
                ResultSet[] param = dynamicResults[i];
                ResultSet drs = param[0];
                if (drs == null) continue;
                if (jdbcContext == null) {
                    jdbcContext = (ConnectionContext)((Object)this.lcc.getContextManager().getContext("JDBC_ConnectionContext"));
                }
                try {
                    try {
                        if (!jdbcContext.processInaccessibleDynamicResult(drs)) {
                            var10_9 = null;
                            param[0] = null;
                            continue;
                        }
                        drs.close();
                    }
                    catch (SQLException e) {
                        if (errorOnClose == null) {
                            StandardException se;
                            errorOnClose = se = StandardException.plainWrapException(e);
                        }
                        var10_9 = null;
                        param[0] = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    param[0] = null;
                    throw throwable;
                }
                var10_9 = null;
                param[0] = null;
            }
            if (errorOnClose != null) {
                throw errorOnClose;
            }
        }
    }

    public void cleanUp() throws StandardException {
        this.close();
    }
}

